/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.module;

import lombok.*;
import java.util.*;
import io.swagger.annotations.*;
import com.faasadmin.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;

import static com.faasadmin.framework.common.utils.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@ApiModel("模块分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SaasModulePageReqVO extends PageParam {

    @ApiModelProperty(value = "模块名称")
    private String name;

    @ApiModelProperty(value = "模块类型")
    private String type;

    @ApiModelProperty(value = "模块状态")
    private String status;

    @ApiModelProperty(value = "模块排序")
    private Integer sort;

    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    @ApiModelProperty(value = "开始创建时间")
    private Date beginCreateTime;

    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    @ApiModelProperty(value = "结束创建时间")
    private Date endCreateTime;

}
