/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.convert.lesseeConfig;

import com.alibaba.fastjson.JSON;
import com.faasadmin.faas.services.lessee.dal.dataobject.lesseeConfig.SaasLesseeConfigDO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.*;
import com.faasadmin.framework.common.pojo.PageResult;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.*;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.List;


/**
 * 租户配置 Convert
 *
 * @author mszf
 */
@Mapper
public interface SaasLesseeConfigConvert {

    SaasLesseeConfigConvert INSTANCE = Mappers.getMapper(SaasLesseeConfigConvert.class);

    SaasLesseeConfigDO convert(SaasLesseeConfigCreateReqVO bean);

    //使用expression的方式
//            @Mapping(target = "wheels",
//                    expression = "java(com.alibaba.fastjson.JSON." +
//                            "toJSONString(car.getWheels()))")
    //使用qualifiedByName的方式
    //@Mapping(target = "wheels", qualifiedByName = "listToString")
    //使用工具类处理
    @Mapping(target = "value", expression = "java(com.alibaba.fastjson.JSON." + "toJSONString(bean.getValue()))")
    SaasLesseeConfigDO convert(SaasLesseeJsonConfigCreateReqVO bean);

    @Mapping(target = "value", expression = "java(com.alibaba.fastjson.JSON." + "toJSONString(bean.getValue()))")
    SaasLesseeConfigDO convert(SaasLesseeJsonConfigUpdateReqVO bean);

    SaasLesseeConfigDO convert(SaasLesseeConfigUpdateReqVO bean);

    SaasLesseeConfigRespVO convert(SaasLesseeConfigDO bean);

    @Mapping(target = "value", expression = "java(com.alibaba.fastjson.JSON." + "parseObject(bean.getValue()))")
    SaasLesseeJsonConfigRespVO convertToJsonConfig(SaasLesseeConfigDO bean);

    List<SaasLesseeConfigRespVO> convertList(List<SaasLesseeConfigDO> list);

    PageResult<SaasLesseeConfigRespVO> convertPage(PageResult<SaasLesseeConfigDO> page);

    List<SaasLesseeConfigExcelVO> convertList02(List<SaasLesseeConfigDO> list);

    @Named("listToString")
    default String listToString(List<String> wheels){
        return JSON.toJSONString(wheels);
    }
}
