/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.enums;

import com.faasadmin.framework.common.exception.ErrorCode;

/**
 * @version: V1.0
 * @author: mszf
 * @date: 2021-08-29 21:04
 * @description: saas错误码枚举类 使用 2-001-000-000 段
 */
public interface SaasErrorCodeConstants {

    // ========== SAAS 模块 2001000000 ==========
    ErrorCode LESSEE_NOT_EXISTS = new ErrorCode(2001000000, "租户不存在");
    ErrorCode LESSEE_MODULE_NOT_EXISTS = new ErrorCode(2001000001, "租户模块不存在");
    ErrorCode MODULE_NOT_EXISTS = new ErrorCode(2001000002, "模块不存在");
    ErrorCode MODULE_MENU_NOT_EXISTS = new ErrorCode(2001000002, "模块菜单不存在");
    ErrorCode LESSEE_LOGIN_NAME_EXIST = new ErrorCode(2001000003, "登陆账号已存在");
    ErrorCode LESSEE_LOGIN_NAME_CHANGE = new ErrorCode(2001000004, "登陆账号禁止更改");
    ErrorCode LESSEE_LOGIN_MOBILE_EXIST = new ErrorCode(2001000005, "租户手机号已存在");
    ErrorCode APP_PREVIEW_LID_NULL = new ErrorCode(2001000006, "首页预览lid不能为空");
    ErrorCode APP_PREVIEW_LID_ERROR = new ErrorCode(2001000006, "lid参数错误,获取数据为空");
    ErrorCode APP_PREVIEW_PAGE_ERROR = new ErrorCode(2001000007, "获取当前租户首页错误");
    ErrorCode LESSEE_EXPIRED = new ErrorCode(2001000008, "该租户已过期");
    ErrorCode LESSEE_DISABLE = new ErrorCode(2001000008, "该租户被停用");
    // ========== 租户配置 2002000000 ==========
    ErrorCode LESSEE_CONFIG_NOT_EXISTS = new ErrorCode(2002000000, "租户配置不存在");
    ErrorCode LESSEE_CONFIG_NOT_DUPLICATE = new ErrorCode(2002000001, "租户配置 key 重复");

}
