/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.enums.lessee;

/**
 * @version: V1.0
 * @author: mszf
 * @description: 租户配置枚举
 * @data: 2021-10-05 9:30
 **/
public enum LesseeConfigEnums {

    WX_APP_ID("wx_app_id", "微信appId"),
    WX_APP_SECRET("wx_app_secret", "微信appSecret"),
    ;

    private String id;
    private String name;

    LesseeConfigEnums(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static String getName(String id) {
        for (LesseeConfigEnums em : LesseeConfigEnums.values()) {
            if (em.id.equals(id)) {
                return em.name;
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
