/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.enums.lessee;

/**
 * @version: V1.0
 * @author: mszf
 * @description: 租户类型
 * @data: 2021-09-13 13:44
 **/
public enum LesseeTypeEnums {

    TRY_LESSEE("0", "试用会员"),
    VIP_LESSEE("1", "VIP会员"),
    ;

    private String id;
    private String name;

    LesseeTypeEnums(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static String getName(String id) {
        for (LesseeTypeEnums em : LesseeTypeEnums.values()) {
            if (em.id.equals(id)) {
                return em.name;
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
