/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.lessee;

import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeModuleDO;

import java.util.Collection;
import java.util.List;

/**
 * 租户拥有模块 Service 接口
 *
 * @author mszf
 */
public interface SaasLesseeModuleService {

    /**
     * 删除租户拥有模块
     *
     * @param id 编号
     */
    void deleteLesseeModule(Long id);

    /**
     * 获得租户拥有模块
     *
     * @param id 编号
     * @return 租户拥有模块
     */
    SaasLesseeModuleDO getLesseeModule(Long id);

    /**
     * 获得租户拥有模块列表
     *
     * @param ids 编号
     * @return 租户拥有模块列表
     */
    List<SaasLesseeModuleDO> getLesseeModuleList(Collection<Long> ids);

}
