/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.module.impl;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleMenuDO;
import com.faasadmin.faas.services.lessee.dal.mysql.module.SaasModuleMenuMapper;
import com.faasadmin.faas.services.lessee.enums.SaasErrorCodeConstants;
import com.faasadmin.faas.services.lessee.service.module.SaasModuleMenuService;
import com.faasadmin.framework.common.exception.util.ServiceExceptionUtil;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

import static com.faasadmin.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 模块与菜单关联 Service 实现类
 *
 * @author mszf
 */
@Service
@Validated
public class SaasModuleMenuServiceImpl implements SaasModuleMenuService {

    @Resource
    private SaasModuleMenuMapper moduleMenuMapper;

    @Override
    public void deleteModuleMenu(Long id) {
        // 校验存在
        this.validateModuleMenuExists(id);
        // 删除
        moduleMenuMapper.deleteById(id);
    }

    private void validateModuleMenuExists(Long id) {
        if (moduleMenuMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception(SaasErrorCodeConstants.MODULE_MENU_NOT_EXISTS);
        }
    }

    @Override
    public SaasModuleMenuDO getModuleMenu(Long id) {
        return moduleMenuMapper.selectById(id);
    }

    @Override
    public List<SaasModuleMenuDO> getModuleMenuList(Collection<Long> ids) {
        return moduleMenuMapper.selectBatchIds(ids);
    }

}
