/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.module.impl;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleDO;
import com.faasadmin.faas.services.lessee.dal.mysql.module.SaasModuleMapper;
import com.faasadmin.faas.services.lessee.enums.SaasErrorCodeConstants;
import com.faasadmin.faas.services.lessee.service.module.SaasModuleService;
import com.faasadmin.framework.common.exception.util.ServiceExceptionUtil;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

import static com.faasadmin.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 模块 Service 实现类
 *
 * @author mszf
 */
@Service
@Validated
public class SaasModuleServiceImpl implements SaasModuleService {

    @Resource
    private SaasModuleMapper moduleMapper;

    @Override
    public void deleteModule(Long id) {
        // 校验存在
        this.validateModuleExists(id);
        // 删除
        moduleMapper.deleteById(id);
    }

    private void validateModuleExists(Long id) {
        if (moduleMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception(SaasErrorCodeConstants.MODULE_NOT_EXISTS);
        }
    }

    @Override
    public SaasModuleDO getModule(Long id) {
        return moduleMapper.selectById(id);
    }

    @Override
    public List<SaasModuleDO> getModuleList(Collection<Long> ids) {
        return moduleMapper.selectBatchIds(ids);
    }

}
