/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.lessee;

import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeDO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeUpdateReqVO;

import javax.validation.Valid;
import java.util.Collection;
import java.util.List;

/**
 * 租户 Service 接口
 *
 * @author faasadmin
 */
public interface SaasLesseeService {

    /**
     * 创建租户
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createLessee(@Valid SaasLesseeCreateReqVO createReqVO);

    /**
     * 更新租户
     *
     * @param updateReqVO 更新信息
     */
    void updateLessee(@Valid SaasLesseeUpdateReqVO updateReqVO);

    /**
     * 删除租户
     *
     * @param id 编号
     */
    void deleteLessee(Long id);

    /**
     * 获得租户
     *
     * @param id 编号
     * @return 租户
     */
    SaasLesseeDO getLessee(Long id);

    /**
     * 获得租户列表
     *
     * @param ids 编号
     * @return 租户列表
     */
    List<SaasLesseeDO> getLesseeList(Collection<Long> ids);

    /**
     * 校验租户(是否过期，是否被停用)
     *
     * @param lesseeId 租户ID
     */
    SaasLesseeDO checkLessee(Long lesseeId);

}
