/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.moduleMenu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Set;

@ApiModel("赋予租户模板 Request VO")
@Data
public class SaasAssignLesseeModuleReqVO{

    @ApiModelProperty(value = "角色编号", required = true, example = "1")
    @NotNull(message = "租户编号不能为空")
    private Long lesseeId;

    @ApiModelProperty(value = "模块编号列表", example = "1,3,5")
    private Set<Long> moduleIds = Collections.emptySet(); // 兜底

}
