/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.convert.lessee;

import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeModuleDO;
import com.faasadmin.faas.services.lessee.vo.lesseeModule.SaasLesseeModuleCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeModule.SaasLesseeModuleExcelVO;
import com.faasadmin.faas.services.lessee.vo.lesseeModule.SaasLesseeModuleRespVO;
import com.faasadmin.faas.services.lessee.vo.lesseeModule.SaasLesseeModuleUpdateReqVO;
import com.faasadmin.framework.common.pojo.PageResult;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 租户拥有模块 Convert
 *
 * @author faasadmin
 */
@Mapper
public interface SaasLesseeModuleConvert {

    SaasLesseeModuleConvert INSTANCE = Mappers.getMapper(SaasLesseeModuleConvert.class);

    SaasLesseeModuleDO convert(SaasLesseeModuleCreateReqVO bean);

    SaasLesseeModuleDO convert(SaasLesseeModuleUpdateReqVO bean);

    SaasLesseeModuleRespVO convert(SaasLesseeModuleDO bean);

    List<SaasLesseeModuleRespVO> convertList(List<SaasLesseeModuleDO> list);

    PageResult<SaasLesseeModuleRespVO> convertPage(PageResult<SaasLesseeModuleDO> page);

    List<SaasLesseeModuleExcelVO> convertList02(List<SaasLesseeModuleDO> list);

}
