/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.convert.module;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleMenuDO;
import com.faasadmin.faas.services.lessee.vo.moduleMenu.SaasModuleMenuCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.moduleMenu.SaasModuleMenuExcelVO;
import com.faasadmin.faas.services.lessee.vo.moduleMenu.SaasModuleMenuRespVO;
import com.faasadmin.faas.services.lessee.vo.moduleMenu.SaasModuleMenuUpdateReqVO;
import com.faasadmin.framework.common.pojo.PageResult;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 模块与菜单关联 Convert
 *
 * @author faasadmin
 */
@Mapper
public interface SaasModuleMenuConvert {

    SaasModuleMenuConvert INSTANCE = Mappers.getMapper(SaasModuleMenuConvert.class);

    SaasModuleMenuDO convert(SaasModuleMenuCreateReqVO bean);

    SaasModuleMenuDO convert(SaasModuleMenuUpdateReqVO bean);

    SaasModuleMenuRespVO convert(SaasModuleMenuDO bean);

    List<SaasModuleMenuRespVO> convertList(List<SaasModuleMenuDO> list);

    PageResult<SaasModuleMenuRespVO> convertPage(PageResult<SaasModuleMenuDO> page);

    List<SaasModuleMenuExcelVO> convertList02(List<SaasModuleMenuDO> list);

}
