/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.dal.dataobject.lessee;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.faasadmin.framework.common.enums.CommonStatusEnum;
import com.faasadmin.framework.mybatis.plus.core.dataobject.BaseDO;
import lombok.*;

import java.util.Date;

/**
 * 租户 DO
 *
 * @author faasadmin
 */
@TableName(value = "saas_lessee", keepGlobalPrefix = true)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SaasLesseeDO extends BaseDO {

    /**
     * 主键
     */
    @TableId
    private Long id;
    /**
     * 编码
     */
    private String code;
    /**
     * 租户名称
     */
    private String name;
    /**
     * 联系人
     */
    private String contact;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 租户类型
     */
    private String type;
    /**
     * 登录账号
     */
    private String loginAccount;
    /**
     * 登录密码
     */
    private String password;
    /**
     * 到期日期 开始时间
     */
    private Date beginTime;
    /**
     * 到期日期 结束时间
     */
    private Date endTime;
    /**
     * 是否初始化
     */
    private String init;
    /**
     * 租户状态
     *
     * @see CommonStatusEnum
     */
    private String status;

}
