/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.dal.dataobject.lesseeConfig;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.faasadmin.framework.common.utils.JsonUtils;
import com.faasadmin.framework.mybatis.plus.core.dataobject.BaseDO;
import lombok.*;

/**
 * 租户配置 DO
 *
 * @author faasadmin
 */
@TableName(value = "saas_lessee_config",keepGlobalPrefix = true)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SaasLesseeConfigDO extends BaseDO {

    /**
     * 配置主键
     */
    @TableId
    private Long id;
    /**
     * 租户ID
     */
    private Long lesseeId;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * 配置名称
     */
    private String name;
    /**
     * 配置键名
     */
    @TableField(value="`key`")
    private String key;
    /**
     * 配置键值
     */
    private String value;
    /**
     * 备注
     */
    private String remark;

    /**
     * 转成对象
     * @return
     */
    public <T> T transformObj(Class<T> clazz){
        return JsonUtils.parseObject(getValue(),clazz);
    }
}
