/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.dal.dataobject.module;

import lombok.*;
import com.baomidou.mybatisplus.annotation.*;
import com.faasadmin.framework.mybatis.plus.core.dataobject.BaseDO;

/**
 * 模块 DO
 *
 * @author faasadmin
 */
@TableName(value = "saas_module",keepGlobalPrefix = true)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SaasModuleDO extends BaseDO {

    /**
     * 用户ID
     */
    @TableId
    private Long id;
    /**
     * 模块名称
     */
    private String name;
    /**
     * 模块类型
     */
    private String type;
    /**
     * 模块状态
     */
    private String status;
    /**
     * 模块排序
     */
    private Integer sort;

}
