/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.dal.mysql.lesseeConfig;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.faasadmin.faas.services.lessee.dal.dataobject.lesseeConfig.SaasLesseeConfigDO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigExportReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigPageReqVO;
import com.faasadmin.framework.common.pojo.PageResult;
import com.faasadmin.framework.mybatis.plus.core.mapper.BaseMapperX;
import com.faasadmin.framework.mybatis.plus.core.query.QueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 租户配置 Mapper
 *
 * @author faasadmin
 */
@Mapper
public interface SaasLesseeConfigMapper extends BaseMapperX<SaasLesseeConfigDO> {

    default PageResult<SaasLesseeConfigDO> selectPage(SaasLesseeConfigPageReqVO reqVO) {
        return selectPage(reqVO, new QueryWrapperX<SaasLesseeConfigDO>()
                .eqIfPresent("lessee_id", reqVO.getLesseeId())
                .likeIfPresent("name", reqVO.getName())
                .eqIfPresent("key", reqVO.getKey())
                .eqIfPresent("value", reqVO.getValue())
                .eqIfPresent("remark", reqVO.getRemark())
                .betweenIfPresent("create_time", reqVO.getBeginCreateTime(), reqVO.getEndCreateTime())
                .orderByDesc("id")        );
    }

    default List<SaasLesseeConfigDO> selectList(SaasLesseeConfigExportReqVO reqVO) {
        return selectList(new QueryWrapperX<SaasLesseeConfigDO>()
                .eqIfPresent("lessee_id", reqVO.getLesseeId())
                .likeIfPresent("name", reqVO.getName())
                .eqIfPresent("key", reqVO.getKey())
                .eqIfPresent("value", reqVO.getValue())
                .eqIfPresent("remark", reqVO.getRemark())
                .betweenIfPresent("create_time", reqVO.getBeginCreateTime(), reqVO.getEndCreateTime())
                .orderByDesc("id")        );
    }

    default SaasLesseeConfigDO selectByKey(Long lesseeId,String key) {
        return selectOne(new QueryWrapper<SaasLesseeConfigDO>().eq("`key`", key).eq("lessee_id",lesseeId));
    }
}
