/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.lessee.impl;

import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeModuleDO;
import com.faasadmin.faas.services.lessee.dal.mysql.lessee.SaasLesseeModuleMapper;
import com.faasadmin.faas.services.lessee.enums.SaasErrorCodeConstants;
import com.faasadmin.faas.services.lessee.service.lessee.SaasLesseeModuleService;
import com.faasadmin.framework.common.exception.util.ServiceExceptionUtil;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

import static com.faasadmin.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 租户拥有模块 Service 实现类
 *
 * @author faasadmin
 */
@Service
@Validated
public class SaasLesseeModuleServiceImpl implements SaasLesseeModuleService {

    @Resource
    private SaasLesseeModuleMapper lesseeModuleMapper;

    @Override
    public void deleteLesseeModule(Long id) {
        // 校验存在
        this.validateLesseeModuleExists(id);
        // 删除
        lesseeModuleMapper.deleteById(id);
    }

    private void validateLesseeModuleExists(Long id) {
        if (lesseeModuleMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception(SaasErrorCodeConstants.LESSEE_MODULE_NOT_EXISTS);
        }
    }

    @Override
    public SaasLesseeModuleDO getLesseeModule(Long id) {
        return lesseeModuleMapper.selectById(id);
    }

    @Override
    public List<SaasLesseeModuleDO> getLesseeModuleList(Collection<Long> ids) {
        return lesseeModuleMapper.selectBatchIds(ids);
    }

}
