/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.lesseeConfig;

import com.baomidou.mybatisplus.extension.service.IService;
import com.faasadmin.faas.services.lessee.dal.dataobject.lesseeConfig.SaasLesseeConfigDO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.*;
import com.faasadmin.framework.common.pojo.PageResult;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.*;

import javax.validation.Valid;
import java.util.Collection;
import java.util.List;

/**
 * 租户配置 Service 接口
 *
 * @author faasadmin
 */
public interface SaasLesseeConfigService extends IService<SaasLesseeConfigDO> {

    /**
     * 创建租户配置
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createLesseeConfig(@Valid SaasLesseeConfigCreateReqVO createReqVO);

    /**
     * 创建租户配置
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createLesseeConfig(SaasLesseeJsonConfigCreateReqVO createReqVO);
    /**
     * 更新租户配置
     *
     * @param updateReqVO 更新信息
     */
    void updateLesseeConfig(@Valid SaasLesseeConfigUpdateReqVO updateReqVO);

    /**
     * 根据key更新租户配置
     * @param updateReqVO 更新信息
     */
    void updateLesseeConfigByKey(SaasLesseeConfigUpdateReqVO updateReqVO);

    /**
     * 更新租户配置
     *
     * @param updateReqVO 更新信息
     */
    void updateLesseeJsonConfig(@Valid SaasLesseeJsonConfigUpdateReqVO updateReqVO);

    /**
     * 更新租户配置
     *
     * @param updateReqVO 更新信息
     */
    void updateLesseeConfig(SaasLesseeConfigDO updateReqVO);

    /**
     * 删除租户配置
     *
     * @param id 编号
     */
    void deleteLesseeConfig(Long id);

    /**
     * 获得租户配置
     *
     * @param id 编号
     * @return 租户配置
     */
    SaasLesseeConfigDO getLesseeConfig(Long id);

    /**
     * 获取配置信息
     *
     * @return
     */
    <T> T getLesseeConfigObject(String key, Class<T> clazz, Long lesseeId);

    /**
     * 根据参数键，获得参数配置
     *
     * @param key 配置键
     * @return 参数配置
     */
    SaasLesseeConfigDO getLesseeConfigByKey(String key, Long lesseeId,String appId);

    /**
     * 根据参数键，获得参数配置
     *
     * @param key 配置键
     * @return 参数配置
     */
    SaasLesseeConfigDO getLesseeConfigByKey(String key, Long lesseeId);

    /**
     * 获得租户配置列表
     *
     * @param ids 编号
     * @return 租户配置列表
     */
    List<SaasLesseeConfigDO> getLesseeConfigList(Collection<Long> ids);

    /**
     * 获得租户配置分页
     *
     * @param pageReqVO 分页查询
     * @return 租户配置分页
     */
    PageResult<SaasLesseeConfigDO> getLesseeConfigPage(SaasLesseeConfigPageReqVO pageReqVO);

    /**
     * 获得租户配置列表, 用于 Excel 导出
     *
     * @param exportReqVO 查询条件
     * @return 租户配置列表
     */
    List<SaasLesseeConfigDO> getLesseeConfigList(SaasLesseeConfigExportReqVO exportReqVO);

    /**
     * 获得租户配置
     *
     * @param lesseeId 租户名称
     * @param appName  应用名称
     * @param key      关键字
     * @param def      默认值
     * @return 租户配置
     */
    String selectLesseeConfigByKeyToStr(Long lesseeId, String appName, String key, String def);

    /**
     * 获得租户配置
     *
     * @param lesseeId 租户名称
     * @param appName  应用名称
     * @param key      关键字
     * @return 租户配置
     */
    Integer selectLesseeConfigByKeyToInt(Long lesseeId, String appName, String key);

    /**
     * 获得租户配置
     *
     * @param key 关键字
     * @return 租户配置
     */
    Boolean selectLesseeConfigByKeyToBool(Long lesseeId, String appName, String key);

}
