/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.module;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleMenuDO;

import java.util.Collection;
import java.util.List;

/**
 * 模块与菜单关联 Service 接口
 *
 * @author faasadmin
 */
public interface SaasModuleMenuService {

    /**
     * 删除模块与菜单关联
     *
     * @param id 编号
     */
    void deleteModuleMenu(Long id);

    /**
     * 获得模块与菜单关联
     *
     * @param id 编号
     * @return 模块与菜单关联
     */
    SaasModuleMenuDO getModuleMenu(Long id);

    /**
     * 获得模块与菜单关联列表
     *
     * @param ids 编号
     * @return 模块与菜单关联列表
     */
    List<SaasModuleMenuDO> getModuleMenuList(Collection<Long> ids);
}
