/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.service.module;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleDO;

import java.util.Collection;
import java.util.List;

/**
 * 模块 Service 接口
 *
 * @author faasadmin
 */
public interface SaasModuleService {

    /**
     * 删除模块
     *
     * @param id 编号
     */
    void deleteModule(Long id);

    /**
     * 获得模块
     *
     * @param id 编号
     * @return 模块
     */
    SaasModuleDO getModule(Long id);

    /**
     * 获得模块列表
     *
     * @param ids 编号
     * @return 模块列表
     */
    List<SaasModuleDO> getModuleList(Collection<Long> ids);

}
