/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.lessee;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.compress.utils.Sets;

import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@ApiModel("租户创建 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SaasLesseeCreateReqVO extends SaasLesseeBaseVO {

    /**
     * 应用模块,多个逗号分隔
     */
    @ApiModelProperty(value = "应用模块", required = true)
    @NotNull(message = "应用模块不能为空")
    private String applyModule;

    /**
     * 验证码
     */
    private String code;


    public Set<Long> getApplyModules() {
        Set<Long> applyModules = Sets.newHashSet();
        if(ObjectUtil.isNotEmpty(applyModule)){
            List<String> strings = Arrays.asList(applyModule.split(","));
            strings.forEach(s->{
                applyModules.add(Convert.toLong(s));
            });
        }
        return applyModules;
    }

}
