/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.lesseeConfig;

import lombok.*;
import java.util.*;
import io.swagger.annotations.*;
import org.springframework.format.annotation.DateTimeFormat;

import static com.faasadmin.framework.common.utils.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@ApiModel(value = "租户配置 Excel 导出 Request VO", description = "参数和 SaasLesseeConfigPageReqVO 是一致的")
@Data
public class SaasLesseeConfigExportReqVO {

    @ApiModelProperty(value = "租户ID")
    private Long lesseeId;

    @ApiModelProperty(value = "应用ID")
    private String appId;

    @ApiModelProperty(value = "配置名称")
    private String name;

    @ApiModelProperty(value = "配置键名")
    private String key;

    @ApiModelProperty(value = "配置键值")
    private String value;

    @ApiModelProperty(value = "备注")
    private String remark;

    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    @ApiModelProperty(value = "开始创建时间")
    private Date beginCreateTime;

    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    @ApiModelProperty(value = "结束创建时间")
    private Date endCreateTime;

}
