/*
 * Decompiled with CFR 0.152.
 */
package com.faasadmin.faas.services.lessee.service.lessee.impl;

import cn.hutool.core.util.ObjectUtil;
import com.faasadmin.faas.services.lessee.convert.lessee.SaasLesseeConvert;
import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeDO;
import com.faasadmin.faas.services.lessee.dal.mysql.lessee.SaasLesseeMapper;
import com.faasadmin.faas.services.lessee.service.lessee.SaasLesseeService;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeUpdateReqVO;
import com.faasadmin.framework.common.constant.ErrorCodeConstants;
import com.faasadmin.framework.common.enums.CommonStatusEnum;
import com.faasadmin.framework.common.exception.ErrorCode;
import com.faasadmin.framework.common.exception.util.ServiceExceptionUtil;
import com.faasadmin.framework.common.utils.DateUtils;
import com.faasadmin.framework.common.utils.ObjectUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class SaasLesseeServiceImpl
implements SaasLesseeService {
    private static final Logger log = LoggerFactory.getLogger(SaasLesseeServiceImpl.class);
    @Resource
    private SaasLesseeMapper lesseeMapper;

    @Override
    public Long createLessee(SaasLesseeCreateReqVO createReqVO) {
        SaasLesseeDO lessee = SaasLesseeConvert.INSTANCE.convert(createReqVO);
        this.lesseeMapper.insert((Object)lessee);
        return lessee.getId();
    }

    @Override
    public void updateLessee(SaasLesseeUpdateReqVO updateReqVO) {
        this.validateLesseeExists(updateReqVO.getId());
        SaasLesseeDO updateObj = SaasLesseeConvert.INSTANCE.convert(updateReqVO);
        this.lesseeMapper.updateById((Object)updateObj);
    }

    @Override
    public void deleteLessee(Long id) {
        this.validateLesseeExists(id);
        this.lesseeMapper.deleteById(id);
    }

    private void validateLesseeExists(Long id) {
        if (this.lesseeMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_NOT_EXISTS);
        }
    }

    @Override
    public SaasLesseeDO getLessee(Long id) {
        return (SaasLesseeDO)((Object)this.lesseeMapper.selectById(id));
    }

    @Override
    public List<SaasLesseeDO> getLesseeList(Collection<Long> ids) {
        return this.lesseeMapper.selectBatchIds(ids);
    }

    @Override
    public SaasLesseeDO checkLessee(Long lesseeId) {
        SaasLesseeDO lessee = this.getLessee(lesseeId);
        if (ObjectUtil.isEmpty((Object)((Object)lessee))) {
            log.error("\u8be5\u79df\u6237\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u5ba2\u670d!");
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_NOT_EXISTS);
        }
        if (DateUtils.compare((Date)DateUtils.date(), (Date)lessee.getEndTime()) > 0) {
            log.error("\u8be5\u79df\u6237\u5df2\u8fc7\u671f,\u8bf7\u8054\u7cfb\u5ba2\u670d!");
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_EXPIRED);
        }
        String status = lessee.getStatus();
        if (ObjectUtils.equals((Object)CommonStatusEnum.DISABLE.getStatus(), (Object)status)) {
            log.error("\u8be5\u79df\u6237\u88ab\u505c\u7528,\u8bf7\u8054\u7cfb\u5ba2\u670d!");
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_DISABLE);
        }
        return lessee;
    }
}

