/*
 * Decompiled with CFR 0.152.
 */
package com.faasadmin.faas.services.lessee.service.lesseeConfig.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.faasadmin.faas.services.lessee.convert.lesseeConfig.SaasLesseeConfigConvert;
import com.faasadmin.faas.services.lessee.dal.dataobject.lesseeConfig.SaasLesseeConfigDO;
import com.faasadmin.faas.services.lessee.dal.mysql.lesseeConfig.SaasLesseeConfigMapper;
import com.faasadmin.faas.services.lessee.service.lesseeConfig.SaasLesseeConfigService;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigExportReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigPageReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeConfigUpdateReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeJsonConfigCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lesseeConfig.SaasLesseeJsonConfigUpdateReqVO;
import com.faasadmin.framework.common.constant.ErrorCodeConstants;
import com.faasadmin.framework.common.exception.ErrorCode;
import com.faasadmin.framework.common.exception.util.ServiceExceptionUtil;
import com.faasadmin.framework.common.pojo.PageResult;
import com.faasadmin.framework.common.utils.JsonUtils;
import com.faasadmin.framework.common.utils.ObjectUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class SaasLesseeConfigServiceImpl
extends ServiceImpl<SaasLesseeConfigMapper, SaasLesseeConfigDO>
implements SaasLesseeConfigService {
    @Resource
    private SaasLesseeConfigMapper lesseeConfigMapper;

    @Override
    public Long createLesseeConfig(SaasLesseeConfigCreateReqVO createReqVO) {
        this.checkCreateOrUpdate(null, createReqVO.getLesseeId(), createReqVO.getKey());
        SaasLesseeConfigDO lesseeConfig = SaasLesseeConfigConvert.INSTANCE.convert(createReqVO);
        this.lesseeConfigMapper.insert((Object)lesseeConfig);
        return lesseeConfig.getId();
    }

    private void checkCreateOrUpdate(Long id, Long lesseeId, String key) {
        this.checkConfigExists(id);
        this.checkConfigKeyUnique(id, lesseeId, key);
    }

    public SaasLesseeConfigDO checkConfigExists(Long id) {
        if (id == null) {
            return null;
        }
        SaasLesseeConfigDO config = (SaasLesseeConfigDO)((Object)this.lesseeConfigMapper.selectById(id));
        if (config == null) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_CONFIG_NOT_EXISTS);
        }
        return config;
    }

    public void checkConfigKeyUnique(Long id, Long lesseeId, String key) {
        SaasLesseeConfigDO config = this.lesseeConfigMapper.selectByKey(lesseeId, key);
        if (config == null) {
            return;
        }
        if (id == null) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_CONFIG_NOT_DUPLICATE);
        }
        if (!config.getId().equals(id)) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_CONFIG_NOT_DUPLICATE);
        }
    }

    @Override
    public Long createLesseeConfig(SaasLesseeJsonConfigCreateReqVO createReqVO) {
        this.checkCreateOrUpdate(null, createReqVO.getLesseeId(), createReqVO.getKey());
        SaasLesseeConfigDO lesseeConfig = SaasLesseeConfigConvert.INSTANCE.convert(createReqVO);
        this.lesseeConfigMapper.insert((Object)lesseeConfig);
        return lesseeConfig.getId();
    }

    @Override
    public void updateLesseeConfig(SaasLesseeConfigUpdateReqVO updateReqVO) {
        this.checkCreateOrUpdate(Convert.toLong((Object)updateReqVO.getId()), updateReqVO.getLesseeId(), null);
        SaasLesseeConfigDO updateObj = SaasLesseeConfigConvert.INSTANCE.convert(updateReqVO);
        this.lesseeConfigMapper.updateById((Object)updateObj);
    }

    @Override
    public void updateLesseeConfigByKey(SaasLesseeConfigUpdateReqVO updateReqVO) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"`key`", (Object)updateReqVO.getKey());
        updateWrapper.eq((Object)"lessee_id", (Object)updateReqVO.getLesseeId());
        updateWrapper.set((Object)"value", (Object)updateReqVO.getValue());
        this.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void updateLesseeJsonConfig(SaasLesseeJsonConfigUpdateReqVO updateReqVO) {
        this.checkCreateOrUpdate(Convert.toLong((Object)updateReqVO.getId()), updateReqVO.getLesseeId(), null);
        SaasLesseeConfigDO updateObj = SaasLesseeConfigConvert.INSTANCE.convert(updateReqVO);
        this.lesseeConfigMapper.updateById((Object)updateObj);
    }

    @Override
    public void updateLesseeConfig(SaasLesseeConfigDO updateReqVO) {
        this.checkCreateOrUpdate(Convert.toLong((Object)updateReqVO.getId()), updateReqVO.getLesseeId(), null);
        this.lesseeConfigMapper.updateById((Object)updateReqVO);
    }

    @Override
    public void deleteLesseeConfig(Long id) {
        this.validateLesseeConfigExists(id);
        this.lesseeConfigMapper.deleteById(id);
    }

    private void validateLesseeConfigExists(Long id) {
        if (this.lesseeConfigMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_CONFIG_NOT_EXISTS);
        }
    }

    @Override
    public SaasLesseeConfigDO getLesseeConfig(Long id) {
        return (SaasLesseeConfigDO)((Object)this.lesseeConfigMapper.selectById(id));
    }

    @Override
    public SaasLesseeConfigDO getLesseeConfigByKey(Long lesseeId, Long appId, String key) {
        return this.lesseeConfigMapper.selectByKey(lesseeId, appId, key);
    }

    @Override
    public List<SaasLesseeConfigDO> getLesseeConfigList(Collection<Long> ids) {
        return this.lesseeConfigMapper.selectBatchIds(ids);
    }

    @Override
    public PageResult<SaasLesseeConfigDO> getLesseeConfigPage(SaasLesseeConfigPageReqVO pageReqVO) {
        return this.lesseeConfigMapper.selectPage(pageReqVO);
    }

    @Override
    public List<SaasLesseeConfigDO> getLesseeConfigList(SaasLesseeConfigExportReqVO exportReqVO) {
        return this.lesseeConfigMapper.selectList(exportReqVO);
    }

    @Override
    public String getLesseeConfigByKeyToStr(Long lesseeId, Long appId, String keys, String def) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"lessee_id", (Object)lesseeId)).eq((Object)"app_id", (Object)appId)).eq((Object)"`key`", (Object)keys);
        SaasLesseeConfigDO saasLesseeConfigDO = (SaasLesseeConfigDO)((Object)this.lesseeConfigMapper.selectOne((Wrapper)queryWrapper));
        if (ObjectUtil.isEmpty((Object)((Object)saasLesseeConfigDO))) {
            return def;
        }
        return saasLesseeConfigDO.getValue();
    }

    @Override
    public Integer getLesseeConfigByKeyToInt(Long lesseeId, Long appId, String key) {
        return Convert.toInt((Object)this.getLesseeConfigByKeyToStr(lesseeId, appId, key, "0"));
    }

    @Override
    public Boolean getLesseeConfigByKeyToBool(Long lesseeId, Long appId, String key) {
        return Convert.toBool((Object)this.getLesseeConfigByKeyToStr(lesseeId, appId, key, "0"));
    }

    @Override
    public Long getLesseeConfigByKeyToLong(Long lesseeId, Long appId, String key) {
        return Convert.toLong((Object)this.getLesseeConfigByKeyToStr(lesseeId, appId, key, "0"));
    }

    @Override
    public <T> T getConfigToClass(Long lesseeId, Long appId, String key, Class<T> clazz) {
        SaasLesseeConfigDO lesseeConfigByKey = this.getLesseeConfigByKey(lesseeId, appId, key);
        if (ObjectUtils.isEmpty((Object)((Object)lesseeConfigByKey))) {
            throw ServiceExceptionUtil.exception((ErrorCode)ErrorCodeConstants.LESSEE_CONFIG_NOT_EXISTS);
        }
        return (T)JsonUtils.parseObject((String)lesseeConfigByKey.getValue(), clazz);
    }

    @Override
    public List<SaasLesseeConfigDO> getLesseeConfigListByKey(String key) {
        return this.lesseeConfigMapper.selectListByKey(key);
    }
}

