/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.private_.JsonParser;
import com.fasterxml.jackson.jr.private_.JsonToken;
import java.io.IOException;

public abstract class ValueReader {
    public abstract Object read(JSONReader var1, JsonParser var2) throws IOException;

    public abstract Object readNext(JSONReader var1, JsonParser var2) throws IOException;

    protected String _tokenDesc(JsonParser jsonParser) throws IOException {
        return ValueReader._tokenDesc(jsonParser, jsonParser.getCurrentToken());
    }

    protected static String _tokenDesc(JsonParser jsonParser, JsonToken jsonToken) throws IOException {
        if (jsonToken == null) {
            return "NULL";
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return "JSON Field name '" + jsonParser.getCurrentName() + "'";
            }
            case START_ARRAY: {
                return "JSON Array";
            }
            case START_OBJECT: {
                return "JSON Object";
            }
            case VALUE_FALSE: {
                return "'false'";
            }
            case VALUE_NULL: {
                return "'null'";
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return "JSON Number";
            }
            case VALUE_STRING: {
                return "JSON String";
            }
            case VALUE_TRUE: {
                return "'true'";
            }
        }
        return jsonToken.toString();
    }
}

