/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.jr.private_.JsonGenerator;
import com.fasterxml.jackson.jr.private_.JsonPointer;
import com.fasterxml.jackson.jr.private_.JsonToken;
import com.fasterxml.jackson.jr.private_.TreeNode;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsMissing;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JrsArray
extends JrsValue {
    private final List<JrsValue> _values;

    public JrsArray() {
        this._values = Collections.emptyList();
    }

    public JrsArray(List<JrsValue> list) {
        this._values = list;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._values.size();
    }

    @Override
    public boolean isValueNode() {
        return false;
    }

    @Override
    public boolean isContainerNode() {
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JrsValue get(int n) {
        return 0 <= n && n < this._values.size() ? this._values.get(n) : null;
    }

    @Override
    public TreeNode get(String string) {
        return null;
    }

    @Override
    public JrsValue path(int n) {
        return 0 <= n && n < this._values.size() ? this._values.get(n) : JrsMissing.instance();
    }

    @Override
    public TreeNode path(String string) {
        return JrsMissing.instance();
    }

    @Override
    protected JrsValue _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingIndex());
    }

    public Iterator<JrsValue> elements() {
        if (this._values.isEmpty()) {
            return this._values.iterator();
        }
        return Collections.unmodifiableList(this._values).iterator();
    }

    @Override
    protected void write(JsonGenerator jsonGenerator, JacksonJrsTreeCodec jacksonJrsTreeCodec) throws IOException {
        jsonGenerator.writeStartArray();
        int n = this._values.size();
        for (int i = 0; i < n; ++i) {
            jacksonJrsTreeCodec.writeTree(jsonGenerator, this._values.get(i));
        }
        jsonGenerator.writeEndArray();
    }
}

