/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.InternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLOntologyImpl
extends OWLObjectImpl
implements OWLMutableOntology,
Serializable {
    private static final long serialVersionUID = 30402L;
    private final OWLOntologyManager manager;
    protected OWLOntologyID ontologyID;
    protected Internals internals;
    OWLAxiomSearchFilter<OWLDatatypeDefinitionAxiom, OWLDatatype> datatypeDefFilter = new OWLAxiomSearchFilter<OWLDatatypeDefinitionAxiom, OWLDatatype>(){
        private static final long serialVersionUID = 30402L;

        public boolean pass(OWLDatatypeDefinitionAxiom axiom, OWLDatatype p) {
            return axiom.getDatatype().equals(p);
        }

        public AxiomType<OWLDatatypeDefinitionAxiom> getAxiomType() {
            return AxiomType.DATATYPE_DEFINITION;
        }
    };
    OWLAxiomSearchFilter<OWLSubAnnotationPropertyOfAxiom, OWLAnnotationProperty> subAnnPropertyFilter = new OWLAxiomSearchFilter<OWLSubAnnotationPropertyOfAxiom, OWLAnnotationProperty>(){
        private static final long serialVersionUID = 30402L;

        public boolean pass(OWLSubAnnotationPropertyOfAxiom axiom, OWLAnnotationProperty p) {
            return axiom.getSubProperty().equals(p);
        }

        public AxiomType<OWLSubAnnotationPropertyOfAxiom> getAxiomType() {
            return AxiomType.SUB_ANNOTATION_PROPERTY_OF;
        }
    };
    OWLAxiomSearchFilter<OWLAnnotationPropertyRangeAxiom, OWLAnnotationProperty> apRangeFilter = new OWLAxiomSearchFilter<OWLAnnotationPropertyRangeAxiom, OWLAnnotationProperty>(){
        private static final long serialVersionUID = 30402L;

        public boolean pass(OWLAnnotationPropertyRangeAxiom axiom, OWLAnnotationProperty p) {
            return axiom.getProperty().equals(p);
        }

        public AxiomType<OWLAnnotationPropertyRangeAxiom> getAxiomType() {
            return AxiomType.ANNOTATION_PROPERTY_RANGE;
        }
    };
    OWLAxiomSearchFilter<OWLAnnotationPropertyDomainAxiom, OWLAnnotationProperty> apDomainFilter = new OWLAxiomSearchFilter<OWLAnnotationPropertyDomainAxiom, OWLAnnotationProperty>(){
        private static final long serialVersionUID = 30402L;

        public boolean pass(OWLAnnotationPropertyDomainAxiom axiom, OWLAnnotationProperty p) {
            return axiom.getProperty().equals(p);
        }

        public AxiomType<OWLAnnotationPropertyDomainAxiom> getAxiomType() {
            return AxiomType.ANNOTATION_PROPERTY_DOMAIN;
        }
    };

    public OWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        this.manager = manager;
        this.ontologyID = ontologyID;
        this.internals = new InternalsImpl();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ontology(");
        sb.append(this.ontologyID.toString());
        sb.append(") ");
        sb.append("[Axioms: ");
        sb.append(this.internals.getAxiomCount());
        sb.append(" Logical Axioms: ");
        sb.append(this.internals.getLogicalAxiomCount());
        sb.append("]");
        return sb.toString();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public boolean isAnonymous() {
        return this.ontologyID.isAnonymous();
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        if (object == this) {
            return 0;
        }
        OWLOntology other = (OWLOntology)object;
        return this.ontologyID.compareTo(other.getOntologyID());
    }

    public boolean isEmpty() {
        return this.internals.isEmpty();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomCount(axiomType);
        }
        int result = 0;
        for (OWLOntology ont : this.getImportsClosure()) {
            result += ont.getAxiomCount(axiomType);
        }
        return result;
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return this.internals.contains(this.internals.getAxiomsByType(), axiom.getAxiomType(), axiom);
    }

    public int getAxiomCount() {
        return this.internals.getAxiomCount();
    }

    public Set<OWLAxiom> getAxioms() {
        return this.internals.getAxioms();
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return this.internals.getValues(this.internals.getAxiomsByType(), axiomType);
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (includeImportsClosure) {
            Set toReturn = CollectionFactory.createSet();
            for (OWLOntology o : this.getImportsClosure()) {
                toReturn.addAll(o.getAxioms(axiomType));
            }
            return toReturn;
        }
        return this.getAxioms(axiomType);
    }

    public Set<OWLAxiom> getTBoxAxioms(boolean includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.TBoxAxiomTypes) {
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    public Set<OWLAxiom> getABoxAxioms(boolean includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.ABoxAxiomTypes) {
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    public Set<OWLAxiom> getRBoxAxioms(boolean includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.RBoxAxiomTypes) {
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.internals.getAxiomCount(axiomType);
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.internals.getLogicalAxioms();
    }

    public int getLogicalAxiomCount() {
        return this.internals.getLogicalAxiomCount();
    }

    public Set<OWLAnnotation> getAnnotations() {
        return this.internals.getOntologyAnnotations();
    }

    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        return this.internals.getValues(this.internals.getDeclarationsByEntity(), entity);
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        return this.internals.getValues(this.internals.getAnnotationAssertionAxiomsBySubject(), subject);
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.internals.getGeneralClassAxioms();
    }

    public boolean containsAxiom(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiom(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiom(axiom)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        Set<OWLAxiom> set = this.internals.getValues(this.internals.getAxiomsByType(), axiom.getAxiomType());
        for (OWLAxiom ax : set) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiomIgnoreAnnotations(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiomIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        Set result = CollectionFactory.createSet();
        if (this.containsAxiom(axiom)) {
            result.add(axiom);
        }
        Set<OWLAxiom> set = this.internals.getValues(this.internals.getAxiomsByType(), axiom.getAxiomType());
        for (OWLAxiom ax : set) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            result.add(ax);
        }
        return result;
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomsIgnoreAnnotations(axiom);
        }
        Set result = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxiomsIgnoreAnnotations(axiom));
        }
        return result;
    }

    public boolean containsClassInSignature(IRI owlClassIRI) {
        return this.containsReference(OWLOntologyImpl.getOWLDataFactory().getOWLClass(owlClassIRI));
    }

    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsClassInSignature(owlClassIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsClassInSignature(owlClassIRI)) continue;
            return true;
        }
        return false;
    }

    public boolean containsObjectPropertyInSignature(IRI propIRI) {
        return this.containsReference(OWLOntologyImpl.getOWLDataFactory().getOWLObjectProperty(propIRI));
    }

    public boolean containsObjectPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsObjectPropertyInSignature(propIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsObjectPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDataPropertyInSignature(IRI propIRI) {
        return this.containsReference(OWLOntologyImpl.getOWLDataFactory().getOWLDataProperty(propIRI));
    }

    public boolean containsDataPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsDataPropertyInSignature(propIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsDataPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnnotationPropertyInSignature(IRI propIRI) {
        OWLAnnotationProperty owlAnnotationProperty = OWLOntologyImpl.getOWLDataFactory().getOWLAnnotationProperty(propIRI);
        boolean b = this.containsReference(owlAnnotationProperty);
        if (b) {
            return true;
        }
        for (OWLAnnotation anno : this.internals.getOntologyAnnotations()) {
            if (!anno.getProperty().equals(owlAnnotationProperty)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnnotationPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAnnotationPropertyInSignature(propIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsAnnotationPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndividualInSignature(IRI individualIRI) {
        return this.containsReference(OWLOntologyImpl.getOWLDataFactory().getOWLNamedIndividual(individualIRI));
    }

    public boolean containsIndividualInSignature(IRI individualIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsIndividualInSignature(individualIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsIndividualInSignature(individualIRI)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDatatypeInSignature(IRI datatypeIRI) {
        return this.containsReference(OWLOntologyImpl.getOWLDataFactory().getOWLDatatype(datatypeIRI));
    }

    public boolean containsDatatypeInSignature(IRI datatypeIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsDatatypeInSignature(datatypeIRI);
        }
        for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
            if (!ont.containsDatatypeInSignature(datatypeIRI)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        Set result = CollectionFactory.createSet((int)6);
        if (this.containsClassInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLClass(iri));
        }
        if (this.containsObjectPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLObjectProperty(iri));
        }
        if (this.containsDataPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDataProperty(iri));
        }
        if (this.containsIndividualInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLNamedIndividual(iri));
        }
        if (this.containsDatatypeInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDatatype(iri));
        }
        if (this.containsAnnotationPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLAnnotationProperty(iri));
        }
        return result;
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getEntitiesInSignature(iri);
        }
        Set result = CollectionFactory.createSet((int)6);
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getEntitiesInSignature(iri));
        }
        return result;
    }

    public boolean containsReference(OWLClass owlClass) {
        return this.internals.contains(this.internals.getOwlClassReferences(), owlClass);
    }

    public boolean containsReference(OWLObjectProperty prop) {
        return this.internals.contains(this.internals.getOwlObjectPropertyReferences(), prop);
    }

    public boolean containsReference(OWLDataProperty prop) {
        return this.internals.contains(this.internals.getOwlDataPropertyReferences(), prop);
    }

    public boolean containsReference(OWLNamedIndividual ind) {
        return this.internals.contains(this.internals.getOwlIndividualReferences(), ind);
    }

    public boolean containsReference(OWLDatatype dt) {
        return this.internals.contains(this.internals.getOwlDatatypeReferences(), dt);
    }

    public boolean containsReference(OWLAnnotationProperty property) {
        return this.internals.contains(this.internals.getOwlAnnotationPropertyReferences(), property);
    }

    public boolean isDeclared(OWLEntity entity) {
        return this.internals.isDeclared(OWLOntologyImpl.getOWLDataFactory().getOWLDeclarationAxiom(entity));
    }

    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        return this.internals.filterAxioms(this.datatypeDefFilter, datatype);
    }

    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        return this.internals.filterAxioms(this.subAnnPropertyFilter, subProperty);
    }

    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        return this.internals.filterAxioms(this.apDomainFilter, property);
    }

    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        return this.internals.filterAxioms(this.apRangeFilter, property);
    }

    public boolean isDeclared(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (this.isDeclared(owlEntity)) {
            return true;
        }
        if (includeImportsClosure) {
            for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
                if (ont.equals(this) || !ont.isDeclared(owlEntity)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();
        return entityReferenceChecker.containsReference(owlEntity);
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(owlEntity);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(owlEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntityInSignature(IRI entityIRI) {
        if (this.containsClassInSignature(entityIRI)) {
            return true;
        }
        if (this.containsObjectPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDataPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsIndividualInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDatatypeInSignature(entityIRI)) {
            return true;
        }
        return this.containsAnnotationPropertyInSignature(entityIRI);
    }

    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(entityIRI);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(entityIRI)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        ReferencedAxiomsCollector referencedAxiomsCollector = new ReferencedAxiomsCollector();
        return (Set)owlEntity.accept((OWLEntityVisitorEx)referencedAxiomsCollector);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getReferencingAxioms(owlEntity);
        }
        Set result = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getReferencingAxioms(owlEntity));
        }
        return result;
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLAnonymousIndividual individual) {
        return this.internals.getValues(this.internals.getOwlAnonymousIndividualReferences(), individual);
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        return this.internals.getValues(this.internals.getClassAxiomsByClass(), cls);
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression prop) {
        Set result = CollectionFactory.createSet((int)50);
        result.addAll(this.getAsymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getReflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getSymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getIrreflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getTransitiveObjectPropertyAxioms(prop));
        result.addAll(this.getInverseFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getInverseObjectPropertyAxioms(prop));
        result.addAll(this.getObjectPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentObjectPropertiesAxioms(prop));
        result.addAll(this.getDisjointObjectPropertiesAxioms(prop));
        result.addAll(this.getObjectPropertyRangeAxioms(prop));
        result.addAll(this.getObjectSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty prop) {
        Set result = CollectionFactory.createSet();
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!ax.getSubProperty().equals(prop)) continue;
            result.add(ax);
        }
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!ax.getProperty().equals(prop)) continue;
            result.add(ax);
        }
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!ax.getProperty().equals(prop)) continue;
            result.add(ax);
        }
        return result;
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty prop) {
        Set result = CollectionFactory.createSet();
        result.addAll(this.getDataPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentDataPropertiesAxioms(prop));
        result.addAll(this.getDisjointDataPropertiesAxioms(prop));
        result.addAll(this.getDataPropertyRangeAxioms(prop));
        result.addAll(this.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)prop));
        result.addAll(this.getDataSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        Set result = CollectionFactory.createSet();
        result.addAll(this.getClassAssertionAxioms(individual));
        result.addAll(this.getObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getDataPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
        result.addAll(this.getSameIndividualAxioms(individual));
        result.addAll(this.getDifferentIndividualAxioms(individual));
        return result;
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.getDatatypeDefinitions(datatype);
    }

    @Deprecated
    public Set<OWLNamedObject> getReferencedObjects() {
        Set result = CollectionFactory.createSet();
        result.addAll(this.internals.getKeyset(this.internals.getOwlClassReferences()));
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : this.internals.getKeyset(this.internals.getOwlObjectPropertyReferences())) {
            if (oWLObjectPropertyExpression.isAnonymous()) continue;
            result.add((OWLObjectProperty)oWLObjectPropertyExpression);
        }
        result.addAll(this.internals.getKeyset(this.internals.getOwlDataPropertyReferences()));
        result.addAll(this.internals.getKeyset(this.internals.getOwlIndividualReferences()));
        return result;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        Set entities = CollectionFactory.createSet();
        entities.addAll(this.getClassesInSignature());
        entities.addAll(this.getObjectPropertiesInSignature());
        entities.addAll(this.getDataPropertiesInSignature());
        entities.addAll(this.getIndividualsInSignature());
        entities.addAll(this.getDatatypesInSignature());
        entities.addAll(this.getAnnotationPropertiesInSignature());
        return entities;
    }

    public Set<OWLEntity> getSignature(boolean includeImportsClosure) {
        Set<OWLEntity> entities = this.getSignature();
        if (includeImportsClosure) {
            for (OWLOntology ont : this.getImportsClosure()) {
                if (ont.equals(this)) continue;
                entities.addAll(ont.getSignature());
            }
        }
        return entities;
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.internals.getKeyset(this.internals.getOwlAnonymousIndividualReferences());
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return this.internals.getKeyset(this.internals.getOwlClassReferences());
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.internals.getKeyset(this.internals.getOwlDataPropertyReferences());
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.internals.getKeyset(this.internals.getOwlObjectPropertyReferences());
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.internals.getKeyset(this.internals.getOwlIndividualReferences());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.internals.getKeyset(this.internals.getOwlDatatypeReferences());
    }

    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getClassesInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getClassesInSignature());
        }
        return results;
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getObjectPropertiesInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getObjectPropertiesInSignature());
        }
        return results;
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDataPropertiesInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDataPropertiesInSignature());
        }
        return results;
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getIndividualsInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getIndividualsInSignature());
        }
        return results;
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return this.internals.getKeyset(this.internals.getOwlAnonymousIndividualReferences());
    }

    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDatatypesInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDatatypesInSignature());
        }
        return results;
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        Set props = CollectionFactory.createSet(this.internals.getKeyset(this.internals.getOwlAnnotationPropertyReferences()));
        for (OWLAnnotation anno : this.internals.getOntologyAnnotations()) {
            props.add(anno.getProperty());
        }
        return props;
    }

    @Deprecated
    public Set<OWLAnnotationProperty> getReferencedAnnotationProperties(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAnnotationPropertiesInSignature();
        }
        Set results = CollectionFactory.createSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getAnnotationPropertiesInSignature());
        }
        return results;
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.internals.getImportsDeclarations();
    }

    public Set<IRI> getDirectImportsDocuments() throws UnknownOWLOntologyException {
        Set result = CollectionFactory.createSet();
        for (OWLImportsDeclaration importsDeclaration : this.internals.getImportsDeclarations()) {
            result.add(importsDeclaration.getIRI());
        }
        return result;
    }

    public Set<OWLOntology> getImports() throws UnknownOWLOntologyException {
        return this.manager.getImports((OWLOntology)this);
    }

    public Set<OWLOntology> getDirectImports() throws UnknownOWLOntologyException {
        return this.manager.getDirectImports((OWLOntology)this);
    }

    public Set<OWLOntology> getImportsClosure() throws UnknownOWLOntologyException {
        return this.getOWLOntologyManager().getImportsClosure((OWLOntology)this);
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        return this.internals.getValues(this.internals.getSubClassAxiomsByLHS(), cls);
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        return this.internals.getValues(this.internals.getSubClassAxiomsByRHS(), cls);
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass cls) {
        return this.internals.getValues(this.internals.getEquivalentClassesAxiomsByClass(), cls);
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass cls) {
        return this.internals.getValues(this.internals.getDisjointClassesAxiomsByClass(), cls);
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        return this.internals.getValues(this.internals.getDisjointUnionAxiomsByClass(), owlClass);
    }

    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass cls) {
        return this.internals.getValues(this.internals.getHasKeyAxiomsByClass(), cls);
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getObjectSubPropertyAxiomsByLHS(), property);
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getObjectSubPropertyAxiomsByRHS(), property);
    }

    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getObjectPropertyDomainAxiomsByProperty(), property);
    }

    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getObjectPropertyRangeAxiomsByProperty(), property);
    }

    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getInversePropertyAxiomsByProperty(), property);
    }

    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getEquivalentObjectPropertyAxiomsByProperty(), property);
    }

    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getDisjointObjectPropertyAxiomsByProperty(), property);
    }

    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getFunctionalObjectPropertyAxiomsByProperty(), property);
    }

    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getInverseFunctionalPropertyAxiomsByProperty(), property);
    }

    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getSymmetricPropertyAxiomsByProperty(), property);
    }

    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getAsymmetricPropertyAxiomsByProperty(), property);
    }

    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getReflexivePropertyAxiomsByProperty(), property);
    }

    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getIrreflexivePropertyAxiomsByProperty(), property);
    }

    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.internals.getValues(this.internals.getTransitivePropertyAxiomsByProperty(), property);
    }

    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.internals.getValues(this.internals.getFunctionalDataPropertyAxiomsByProperty(), property);
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty lhsProperty) {
        return this.internals.getValues(this.internals.getDataSubPropertyAxiomsByLHS(), lhsProperty);
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.internals.getValues(this.internals.getDataSubPropertyAxiomsByRHS(), property);
    }

    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        return this.internals.getValues(this.internals.getDataPropertyDomainAxiomsByProperty(), property);
    }

    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        return this.internals.getValues(this.internals.getDataPropertyRangeAxiomsByProperty(), property);
    }

    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.internals.getValues(this.internals.getEquivalentDataPropertyAxiomsByProperty(), property);
    }

    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.internals.getValues(this.internals.getDisjointDataPropertyAxiomsByProperty(), property);
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getClassAssertionAxiomsByIndividual(), individual);
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression type) {
        return this.internals.getValues(this.internals.getClassAssertionAxiomsByClass(), type);
    }

    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getDataPropertyAssertionsByIndividual(), individual);
    }

    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getObjectPropertyAssertionsByIndividual(), individual);
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getNegativeObjectPropertyAssertionAxiomsByIndividual(), individual);
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getNegativeDataPropertyAssertionAxiomsByIndividual(), individual);
    }

    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getSameIndividualsAxiomsByIndividual(), individual);
    }

    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        return this.internals.getValues(this.internals.getDifferentIndividualsAxiomsByIndividual(), individual);
    }

    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(2);
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        change.accept((OWLOntologyChangeVisitor)changeFilter);
        List<OWLOntologyChange> applied = changeFilter.getAppliedChanges();
        if (applied.size() == 1) {
            appliedChanges.add(change);
        } else {
            appliedChanges.addAll(applied);
        }
        return appliedChanges;
    }

    public List<OWLOntologyChange> applyChanges(List<OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange change : changes) {
            change.accept((OWLOntologyChangeVisitor)changeFilter);
            appliedChanges.addAll(changeFilter.getAppliedChanges());
            changeFilter.reset();
        }
        return appliedChanges;
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLOntology)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLOntology)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLOntology)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return this.ontologyID.equals((Object)other.getOntologyID());
    }

    @Override
    public int hashCode() {
        return this.ontologyID.hashCode();
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor,
    Serializable {
        private static final long serialVersionUID = 30402L;
        private boolean ref;

        public boolean containsReference(OWLEntity entity) {
            this.ref = false;
            entity.accept((OWLEntityVisitor)this);
            return this.ref;
        }

        public void visit(OWLClass cls) {
            this.ref = OWLOntologyImpl.this.containsReference(cls);
        }

        public void visit(OWLDatatype datatype) {
            this.ref = OWLOntologyImpl.this.containsReference(datatype);
        }

        public void visit(OWLNamedIndividual individual) {
            this.ref = OWLOntologyImpl.this.containsReference(individual);
        }

        public void visit(OWLDataProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLObjectProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLAnnotationProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }
    }

    protected class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitor,
    Serializable {
        private static final long serialVersionUID = 30402L;
        private final List<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();

        public List<OWLOntologyChange> getAppliedChanges() {
            return this.appliedChanges;
        }

        public void reset() {
            this.appliedChanges.clear();
        }

        public void visit(RemoveAxiom change) {
            if (OWLOntologyImpl.this.internals.removeAxiom(change.getAxiom())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }

        public void visit(SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals((Object)OWLOntologyImpl.this.ontologyID)) {
                this.appliedChanges.add((OWLOntologyChange)change);
                OWLOntologyImpl.this.ontologyID = id;
            }
        }

        public void visit(AddAxiom change) {
            if (OWLOntologyImpl.this.internals.addAxiom(change.getAxiom())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }

        public void visit(AddImport change) {
            if (OWLOntologyImpl.this.internals.addImportsDeclaration(change.getImportDeclaration())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }

        public void visit(RemoveImport change) {
            if (OWLOntologyImpl.this.internals.removeImportsDeclaration(change.getImportDeclaration())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }

        public void visit(AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.internals.addOntologyAnnotation(change.getAnnotation())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }

        public void visit(RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.internals.removeOntologyAnnotation(change.getAnnotation())) {
                this.appliedChanges.add((OWLOntologyChange)change);
            }
        }
    }

    private final class ReferencedAxiomsCollector
    implements OWLEntityVisitorEx<Set<OWLAxiom>> {
        public Set<OWLAxiom> visit(OWLClass cls) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlClassReferences(), cls);
        }

        public Set<OWLAxiom> visit(OWLObjectProperty property) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlObjectPropertyReferences(), property);
        }

        public Set<OWLAxiom> visit(OWLDataProperty property) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlDataPropertyReferences(), property);
        }

        public Set<OWLAxiom> visit(OWLNamedIndividual individual) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlIndividualReferences(), individual);
        }

        public Set<OWLAxiom> visit(OWLDatatype datatype) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlDatatypeReferences(), datatype);
        }

        public Set<OWLAxiom> visit(OWLAnnotationProperty property) {
            return OWLOntologyImpl.this.internals.getValues(OWLOntologyImpl.this.internals.getOwlAnnotationPropertyReferences(), property);
        }
    }
}

