/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;

import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;


/**
 * Author: Matthew Horridge<br>
 * The University Of Manchester<br>
 * Bio-Health Informatics Group<br>
 * Date: 26-Oct-2006<br><br>
 *
 * @param <P> the property expression
 * @param <O> the object
 */
public abstract class OWLIndividualRelationshipAxiomImpl<P extends OWLPropertyExpression<?,?>, O extends OWLPropertyAssertionObject> extends OWLLogicalAxiomImpl implements OWLPropertyAssertionAxiom<P, O> {


	private static final long serialVersionUID = 30406L;

	private final OWLIndividual subject;

    private final P property;

    private final O object;


    /**
     * @param subject the subject
     * @param property the property
     * @param object the object
     * @param annotations the annotations
     */
    public OWLIndividualRelationshipAxiomImpl(OWLIndividual subject, P property, O object, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subject = subject;
        this.property = property;
        this.object = object;
    }


    @Override
    public OWLIndividual getSubject() {
        return subject;
    }


    @Override
    public P getProperty() {
        return property;
    }


    @Override
    public O getObject() {
        return object;
    }


    @Override
	public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLPropertyAssertionAxiom)) {
                return false;
            }
            OWLPropertyAssertionAxiom<?,?> other = (OWLPropertyAssertionAxiom<?,?>) obj;
            return other.getSubject().equals(subject) && other.getProperty().equals(property) && other.getObject().equals(object);
        }
        return false;
    }


    @Override
	final protected int compareObjectOfSameType(OWLObject o) {
        OWLPropertyAssertionAxiom<?,?> other = (OWLPropertyAssertionAxiom<?,?>) o;
        int diff = subject.compareTo(other.getSubject());
        if (diff != 0) {
            return diff;
        }
        diff = property.compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return o.compareTo(other.getObject());
    }
}
