/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplNoCompression
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    static final String utf_8 = "UTF-8";
    private static final OWLDatatype RDF_PLAIN_LITERAL = OWL2DatatypeImpl.getDatatype(OWL2Datatype.RDF_PLAIN_LITERAL);
    private final byte[] literal;
    private final OWLDatatype datatype;
    private final String lang;
    private final int hashcode;

    public OWLLiteralImplNoCompression(String literal, String lang, OWLDatatype datatype) {
        this(OWLLiteralImplNoCompression.getBytes(literal), lang, datatype);
    }

    public OWLLiteralImplNoCompression(byte[] bytes, String lang, OWLDatatype datatype) {
        this.literal = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.literal, 0, bytes.length);
        OWLDatatype rdfplainlit = RDF_PLAIN_LITERAL;
        if (lang == null || lang.length() == 0) {
            this.lang = "";
            this.datatype = datatype == null ? rdfplainlit : datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.lang = lang;
            this.datatype = rdfplainlit;
        }
        this.hashcode = this.getHashCode();
    }

    private static byte[] getBytes(String literal) {
        try {
            return literal.getBytes(utf_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported UTF 8 encoding: broken JVM", e);
        }
    }

    public String getLiteral() {
        try {
            return new String(this.literal, utf_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLRuntimeException("Unsupported UTF 8 encoding: broken JVM", (Throwable)e);
        }
    }

    public boolean hasLang() {
        return !this.lang.equals("");
    }

    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    public boolean isInteger() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_INTEGER.getIRI());
    }

    public boolean isBoolean() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public boolean isDouble() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    public boolean isFloat() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_FLOAT.getIRI());
    }

    public boolean parseBoolean() throws NumberFormatException {
        String literal2 = this.getLiteral();
        if (literal2.equals("0")) {
            return false;
        }
        if (literal2.equals("1")) {
            return true;
        }
        if (literal2.equals("true")) {
            return true;
        }
        if (literal2.equals("false")) {
            return false;
        }
        return Boolean.parseBoolean(literal2);
    }

    public double parseDouble() throws NumberFormatException {
        return Double.parseDouble(this.getLiteral());
    }

    public float parseFloat() throws NumberFormatException {
        String literal2 = this.getLiteral();
        if ("inf".equalsIgnoreCase(literal2)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(literal2)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(literal2);
    }

    public String getLang() {
        return this.lang;
    }

    public boolean hasLang(String l) {
        if (l == null && this.lang == null) {
            return true;
        }
        if (l == null) {
            l = "";
        }
        return this.lang != null && this.lang.equalsIgnoreCase(l.trim());
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        try {
            hashCode = this.isInteger() ? (hashCode += this.parseInteger() * 65536) : (this.isDouble() ? (hashCode += (int)this.parseDouble() * 65536) : (this.isFloat() ? (hashCode += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (hashCode += this.parseBoolean() ? 65536 : 0) : (hashCode += this.getLiteral().hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            hashCode += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            if (other instanceof OWLLiteralImplNoCompression) {
                return Arrays.equals(this.literal, ((OWLLiteralImplNoCompression)other).literal) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
            }
            return this.getLiteral().equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }
}

