/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import uk.ac.manchester.cs.owl.owlapi.SWRLAtomImpl;

public class SWRLBuiltInAtomImpl
extends SWRLAtomImpl
implements SWRLBuiltInAtom {
    private static final long serialVersionUID = 30406L;
    private final List<SWRLDArgument> args;

    public SWRLBuiltInAtomImpl(IRI predicate, List<SWRLDArgument> args) {
        super((SWRLPredicate)predicate);
        this.args = new ArrayList<SWRLDArgument>(args);
    }

    public IRI getPredicate() {
        return (IRI)super.getPredicate();
    }

    public boolean isCoreBuiltIn() {
        return SWRLBuiltInsVocabulary.getBuiltIn((URI)this.getPredicate().toURI()) != null;
    }

    public List<SWRLDArgument> getArguments() {
        return new ArrayList<SWRLDArgument>(this.args);
    }

    public Collection<SWRLArgument> getAllArguments() {
        return new ArrayList<SWRLDArgument>(this.args);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((SWRLBuiltInAtom)this);
    }

    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit((SWRLBuiltInAtom)this);
    }

    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLBuiltInAtom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLBuiltInAtom)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SWRLBuiltInAtom)) {
            return false;
        }
        SWRLBuiltInAtom other = (SWRLBuiltInAtom)obj;
        return other.getPredicate().equals((Object)this.getPredicate()) && other.getArguments().equals(this.getArguments());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        SWRLBuiltInAtom other = (SWRLBuiltInAtom)object;
        int diff = this.getPredicate().compareTo((OWLObject)other.getPredicate());
        if (diff != 0) {
            return diff;
        }
        List otherArgs = other.getArguments();
        for (int i = 0; i < this.args.size() && i < otherArgs.size(); ++i) {
            diff = this.args.get(i).compareTo(otherArgs.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return this.args.size() - otherArgs.size();
    }
}

