/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.springdata.v2;

import com.github.cloudyrock.mongock.config.MongockSpringConfigurationBase;
import com.github.cloudyrock.mongock.migration.MongoDbLegacyMigration;
import io.changock.migration.api.config.LegacyMigrationMappingFields;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="changock")
public class SpringDataMongoV2Configuration
extends MongockSpringConfigurationBase {
    public static final String DEFAULT_CHANGELOG_COLLECTION_NAME = "mongockChangeLog";
    public static final String DEFAULT_LOCK_COLLECTION_NAME = "mongockLock";
    private String changeLogCollectionName = "mongockChangeLog";
    private String lockCollectionName = "mongockLock";
    private boolean indexCreation = true;
    private LegacyMigrationConfig legacyMigration = null;

    public String getChangeLogCollectionName() {
        return this.changeLogCollectionName;
    }

    public void setChangeLogCollectionName(String changeLogCollectionName) {
        this.changeLogCollectionName = changeLogCollectionName;
    }

    public String getLockCollectionName() {
        return this.lockCollectionName;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public boolean isIndexCreation() {
        return this.indexCreation;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    public MongoDbLegacyMigration getLegacyMigration() {
        return this.legacyMigration;
    }

    public void setLegacyMigration(LegacyMigrationConfig legacyMigration) {
        this.legacyMigration = legacyMigration;
    }

    public static boolean isLegacyMigrationValid(SpringDataMongoV2Configuration config) {
        return config.getLegacyMigration() == null || StringUtils.isEmpty((CharSequence)config.getLegacyMigration().getCollectionName()) || config.getLegacyMigration().getMappingFields() == null || StringUtils.isEmpty((CharSequence)config.getLegacyMigration().getMappingFields().getChangeId()) || StringUtils.isEmpty((CharSequence)config.getLegacyMigration().getMappingFields().getAuthor());
    }

    public static class LegacyMigrationConfig
    extends MongoDbLegacyMigration {
        @ConfigurationProperties(value="changock.legacy-migration.mapping-fields")
        public LegacyMigrationMappingFields getMappingFields() {
            return super.getMappingFields();
        }
    }
}

