/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.springdata.v2;

import com.github.cloudyrock.mongock.driver.mongodb.springdata.v2.SpringDataMongoV2ChangeEntryRepository;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v2.decorator.impl.MongockTemplate;
import com.github.cloudyrock.mongock.driver.mongodb.v3.driver.MongoCore3Driver;
import io.changock.driver.api.driver.ChangeSetDependency;
import io.changock.driver.api.driver.ForbiddenParametersMap;
import io.changock.driver.api.driver.TransactionStrategy;
import io.changock.driver.api.entry.ChangeEntry;
import io.changock.driver.api.entry.ChangeEntryService;
import io.changock.driver.api.lock.guard.invoker.LockGuardInvoker;
import io.changock.driver.api.lock.guard.invoker.LockGuardInvokerImpl;
import io.changock.migration.api.exception.ChangockException;
import io.changock.utils.annotation.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@NotThreadSafe
public class SpringDataMongoV2Driver
extends MongoCore3Driver {
    private static final Logger logger = LoggerFactory.getLogger(SpringDataMongoV2Driver.class);
    private static final ForbiddenParametersMap FORBIDDEN_PARAMETERS_MAP = new ForbiddenParametersMap();
    private final MongoTemplate mongoTemplate;
    private MongoTransactionManager txManager;

    public static SpringDataMongoV2Driver withDefaultLock(MongoTemplate mongoTemplate) {
        return new SpringDataMongoV2Driver(mongoTemplate, 3L, 4L, 3);
    }

    public static SpringDataMongoV2Driver withLockSetting(MongoTemplate mongoTemplate, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        return new SpringDataMongoV2Driver(mongoTemplate, lockAcquiredForMinutes, maxWaitingForLockMinutes, maxTries);
    }

    protected SpringDataMongoV2Driver(MongoTemplate mongoTemplate, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        super(mongoTemplate.getDb(), lockAcquiredForMinutes, maxWaitingForLockMinutes, maxTries);
        this.mongoTemplate = mongoTemplate;
    }

    public void runValidation() throws ChangockException {
        super.runValidation();
        if (this.mongoTemplate == null) {
            throw new ChangockException("MongoTemplate must not be null");
        }
    }

    public void specificInitialization() {
        super.specificInitialization();
        this.dependencies.add(new ChangeSetDependency(MongockTemplate.class, (Object)new MongockTemplate(this.mongoTemplate, (LockGuardInvoker)new LockGuardInvokerImpl(this.getLockManager()))));
    }

    public ForbiddenParametersMap getForbiddenParameters() {
        return FORBIDDEN_PARAMETERS_MAP;
    }

    public MongockTemplate getMongockTemplate() {
        if (!this.isInitialized()) {
            throw new ChangockException("Mongock Driver hasn't been initialized yet");
        }
        return this.dependencies.stream().filter(dependency -> MongockTemplate.class.isAssignableFrom(dependency.getType())).map(ChangeSetDependency::getInstance).map(instance -> (MongockTemplate)((Object)((Object)instance))).findAny().orElseThrow(() -> new ChangockException("Mongock Driver hasn't been initialized yet"));
    }

    public ChangeEntryService<ChangeEntry> getChangeEntryService() {
        if (this.changeEntryRepository == null) {
            this.changeEntryRepository = new SpringDataMongoV2ChangeEntryRepository(this.mongoTemplate, this.changeLogCollectionName, this.indexCreation);
        }
        return this.changeEntryRepository;
    }

    public void enableTransactionWithTxManager(MongoTransactionManager txManager) {
        this.txManager = txManager;
        this.transactionStrategy = TransactionStrategy.MIGRATION;
    }

    public void executeInTransaction(Runnable operation) {
        TransactionStatus txStatus = this.getTxStatus(this.txManager);
        try {
            this.mongoTemplate.setSessionSynchronization(SessionSynchronization.ALWAYS);
            operation.run();
            this.txManager.commit(txStatus);
        }
        catch (Exception ex) {
            logger.warn("Error in Mongock's transaction", (Throwable)ex);
            this.txManager.rollback(txStatus);
        }
    }

    private TransactionStatus getTxStatus(MongoTransactionManager txManager) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("SomeTxName");
        def.setPropagationBehavior(0);
        return txManager.getTransaction((TransactionDefinition)def);
    }

    static {
        FORBIDDEN_PARAMETERS_MAP.put(MongoTemplate.class, MongockTemplate.class);
    }
}

