/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator;

import com.github.cloudyrock.mongock.driver.api.lock.guard.decorator.Invokable;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.ClientSessionDecoratorImpl;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.MongoDatabaseFactoryDecoratorImpl;
import com.github.cloudyrock.mongock.driver.mongodb.sync.v4.decorator.impl.MongoDataBaseDecoratorImpl;
import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import io.changock.migration.api.annotations.NonLockGuarded;
import java.util.Optional;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDatabaseFactory;

public interface MongoDatabaseFactoryDecorator
extends Invokable,
MongoDatabaseFactory {
    public MongoDatabaseFactory getImpl();

    default public MongoDatabase getMongoDatabase() throws DataAccessException {
        return new MongoDataBaseDecoratorImpl(this.getImpl().getMongoDatabase(), this.getInvoker());
    }

    default public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
        return new MongoDataBaseDecoratorImpl(this.getImpl().getMongoDatabase(dbName), this.getInvoker());
    }

    @NonLockGuarded
    default public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.getImpl().getExceptionTranslator();
    }

    @NonLockGuarded
    default public CodecRegistry getCodecRegistry() {
        return this.getImpl().getCodecRegistry();
    }

    @NonLockGuarded
    default public boolean hasCodecFor(Class<?> type) {
        return this.getImpl().hasCodecFor(type);
    }

    @NonLockGuarded
    default public <T> Optional<Codec<T>> getCodecFor(Class<T> type) {
        return this.getImpl().getCodecFor(type);
    }

    default public ClientSession getSession(ClientSessionOptions options) {
        return new ClientSessionDecoratorImpl((ClientSession)this.getInvoker().invoke(() -> this.getImpl().getSession(options)), this.getInvoker());
    }

    default public MongoDatabaseFactory withSession(ClientSessionOptions options) {
        return new MongoDatabaseFactoryDecoratorImpl((MongoDatabaseFactory)this.getInvoker().invoke(() -> this.getImpl().withSession(options)), this.getInvoker());
    }

    default public MongoDatabaseFactory withSession(ClientSession session) {
        return new MongoDatabaseFactoryDecoratorImpl((MongoDatabaseFactory)this.getInvoker().invoke(() -> this.getImpl().withSession(session)), this.getInvoker());
    }

    @NonLockGuarded
    default public boolean isTransactionActive() {
        return this.getImpl().isTransactionActive();
    }
}

