/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.geo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Util;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.FongoJSON;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;
import org.geojson.GeoJsonObject;
import org.geojson.LngLatAlt;
import org.geojson.MultiPolygon;
import org.geojson.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GeoUtil.class);
    public static boolean illegalForUnknownGeometry = false;
    public static final double EARTH_RADIUS = 6378100.0;
    public static final double METERS_PER_DEGREE = 111185.0;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private GeoUtil() {
    }

    public static boolean geowithin(Geometry p1, Geometry geometry) {
        return DistanceOp.isWithinDistance((Geometry)p1, (Geometry)geometry, (double)0.0);
    }

    public static com.vividsolutions.jts.geom.Point createGeometryPoint(Coordinate coordinate) {
        return GEOMETRY_FACTORY.createPoint(coordinate);
    }

    public static double distanceInRadians(Geometry p1, Geometry p2, boolean spherical) {
        Coordinate[] coordinates = DistanceOp.nearestPoints((Geometry)p1, (Geometry)p2);
        return GeoUtil.distanceInRadians(coordinates[0], coordinates[1], spherical);
    }

    public static double distanceInRadians(Coordinate p1, Coordinate p2, boolean spherical) {
        double distance = spherical ? GeoUtil.distanceSpherical(p1, p2) : GeoUtil.distance2d(p1, p2);
        return distance;
    }

    public static double distance2d(Coordinate p1, Coordinate p2) {
        double a = p1.x - p2.x;
        double b = p1.y - p2.y;
        if (a == 0.0) {
            return Math.abs(b);
        }
        if (b == 0.0) {
            return Math.abs(a);
        }
        return Math.sqrt(a * a + b * b);
    }

    public static double distanceSpherical(Coordinate p1, Coordinate p2) {
        double p1lat = Math.toRadians(p1.x);
        double p1long = Math.toRadians(p1.y);
        double p2lat = Math.toRadians(p2.x);
        double p2long = Math.toRadians(p2.y);
        double sinx1 = Math.sin(p1lat);
        double cosx1 = Math.cos(p1lat);
        double siny1 = Math.sin(p1long);
        double cosy1 = Math.cos(p1long);
        double sinx2 = Math.sin(p2lat);
        double cosx2 = Math.cos(p2lat);
        double siny2 = Math.sin(p2long);
        double cosy2 = Math.cos(p2long);
        double crossProduct = cosx1 * cosx2 * cosy1 * cosy2 + cosx1 * siny1 * cosx2 * siny2 + sinx1 * sinx2;
        if (crossProduct >= 1.0 || crossProduct <= -1.0) {
            return crossProduct > 0.0 ? 0.0 : Math.PI;
        }
        return Math.acos(crossProduct);
    }

    public static List<Coordinate> coordinate(List<String> path, DBObject object) {
        ExpressionParser expressionParser = new ExpressionParser();
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        List<Object> objects = path.isEmpty() ? Collections.singletonList(object) : expressionParser.getEmbeddedValues(path, object);
        for (DBObject value : objects) {
            Coordinate coordinate = GeoUtil.coordinate(value);
            if (coordinate == null) continue;
            result.add(coordinate);
        }
        return result;
    }

    public static Coordinate coordinate(Object value) {
        Coordinate coordinate;
        block19: {
            double[] array;
            coordinate = null;
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 2) {
                    coordinate = new Coordinate(((Number)list.get(1)).doubleValue(), ((Number)list.get(0)).doubleValue());
                } else {
                    LOG.warn("Strange, coordinate of {} has not a size of 2", value);
                }
            } else if (ExpressionParser.isDbObject(value)) {
                DBObject dbObject = ExpressionParser.toDbObject(value);
                if (dbObject.containsField("type")) {
                    try {
                        GeoJsonObject object = (GeoJsonObject)new ObjectMapper().readValue(FongoJSON.serialize(value), GeoJsonObject.class);
                        if (object instanceof Point) {
                            Point point = (Point)object;
                            coordinate = new Coordinate(point.getCoordinates().getLatitude(), point.getCoordinates().getLongitude());
                            break block19;
                        }
                        if (object instanceof org.geojson.Polygon) {
                            org.geojson.Polygon point = (org.geojson.Polygon)object;
                            coordinate = new Coordinate(((LngLatAlt)((List)point.getCoordinates().get(0)).get(0)).getLatitude(), ((LngLatAlt)((List)point.getCoordinates().get(0)).get(0)).getLongitude());
                            break block19;
                        }
                        if (object instanceof MultiPolygon) {
                            MultiPolygon point = (MultiPolygon)object;
                            coordinate = new Coordinate(((LngLatAlt)((List)((List)point.getCoordinates().get(0)).get(0)).get(0)).getLatitude(), ((LngLatAlt)((List)((List)point.getCoordinates().get(0)).get(0)).get(0)).getLongitude());
                            break block19;
                        }
                        throw new IllegalArgumentException("type " + object + " not correctly handle in Fongo");
                    }
                    catch (IOException e) {
                        LOG.warn("don't known how to handle " + value);
                    }
                } else if (dbObject.containsField("lng") && dbObject.containsField("lat")) {
                    coordinate = new Coordinate(((Number)dbObject.get("lat")).doubleValue(), ((Number)dbObject.get("lng")).doubleValue());
                } else if (dbObject.containsField("x") && dbObject.containsField("y")) {
                    coordinate = new Coordinate(((Number)dbObject.get("x")).doubleValue(), ((Number)dbObject.get("y")).doubleValue());
                } else if (dbObject.containsField("latitude") && dbObject.containsField("longitude")) {
                    coordinate = new Coordinate(((Number)dbObject.get("latitude")).doubleValue(), ((Number)dbObject.get("longitude")).doubleValue());
                }
            } else if (value instanceof double[] && (array = (double[])value).length >= 2) {
                coordinate = new Coordinate(((Number)array[0]).doubleValue(), ((Number)array[1]).doubleValue());
            }
        }
        return coordinate;
    }

    public static Geometry toGeometry(Object object) {
        if (ExpressionParser.isDbObject(object)) {
            return GeoUtil.toGeometry(ExpressionParser.toDbObject(object));
        }
        return GeoUtil.createGeometryPoint(GeoUtil.coordinate(object));
    }

    public static Geometry toGeometry(Coordinate coordinate) {
        return GeoUtil.createGeometryPoint(coordinate);
    }

    public static Geometry toGeometry(DBObject dbObject) {
        if (dbObject.containsField("$box")) {
            BasicDBList coordinates = (BasicDBList)dbObject.get("$box");
            return GeoUtil.createBox(coordinates);
        }
        if (dbObject.containsField("$center")) {
            BasicDBList coordinates = (BasicDBList)dbObject.get("$center");
            return GeoUtil.createCircle(coordinates, false);
        }
        if (dbObject.containsField("$centerSphere")) {
            BasicDBList coordinates = (BasicDBList)dbObject.get("$centerSphere");
            return GeoUtil.createCircle(coordinates, true);
        }
        if (dbObject.containsField("$polygon")) {
            BasicDBList coordinates = (BasicDBList)dbObject.get("$polygon");
            return GeoUtil.createPolygon(coordinates);
        }
        if (dbObject.containsField("$geometry")) {
            return GeoUtil.toGeometry(ExpressionParser.toDbObject(dbObject.get("$geometry")));
        }
        if (dbObject.containsField("type")) {
            try {
                GeoJsonObject geoJsonObject = (GeoJsonObject)new ObjectMapper().readValue(FongoJSON.serialize(dbObject), GeoJsonObject.class);
                if (geoJsonObject instanceof Point) {
                    Point point = (Point)geoJsonObject;
                    return GeoUtil.createGeometryPoint(GeoUtil.toCoordinate(point.getCoordinates()));
                }
                if (geoJsonObject instanceof org.geojson.Polygon) {
                    org.geojson.Polygon polygon = (org.geojson.Polygon)geoJsonObject;
                    return GeoUtil.toJtsPolygon(polygon.getCoordinates());
                }
                if (geoJsonObject instanceof MultiPolygon) {
                    MultiPolygon polygon = (MultiPolygon)geoJsonObject;
                    return GEOMETRY_FACTORY.createMultiPolygon(GeoUtil.toJtsPolygons(polygon.getCoordinates()));
                }
            }
            catch (IOException e) {
                LOG.warn("cannot handle " + FongoJSON.serialize(dbObject));
            }
        } else {
            Coordinate coordinate = GeoUtil.coordinate(dbObject);
            if (coordinate != null) {
                return GeoUtil.createGeometryPoint(coordinate);
            }
        }
        if (illegalForUnknownGeometry) {
            throw new IllegalArgumentException("can't handle " + FongoJSON.serialize(dbObject));
        }
        return null;
    }

    public static Polygon toJtsPolygon(List<List<LngLatAlt>> lngLatAlts) {
        if (lngLatAlts.size() > 1 && !lngLatAlts.get(lngLatAlts.size() - 1).equals(lngLatAlts.get(0))) {
            lngLatAlts = new ArrayList<List<LngLatAlt>>(lngLatAlts);
            lngLatAlts.add(lngLatAlts.get(0));
        }
        return GEOMETRY_FACTORY.createPolygon(GeoUtil.toCoordinates(lngLatAlts));
    }

    private static Polygon[] toJtsPolygons(List<List<List<LngLatAlt>>> listPolygonsLngLatAlt) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (List<List<LngLatAlt>> lngLatAlts : listPolygonsLngLatAlt) {
            polygons.add(GeoUtil.toJtsPolygon(lngLatAlts));
        }
        return polygons.toArray(new Polygon[0]);
    }

    private static Coordinate[] toCoordinates(List<List<LngLatAlt>> lngLatAlts) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (List<LngLatAlt> lineStrings : lngLatAlts) {
            for (LngLatAlt lngLatAlt : lineStrings) {
                coordinates.add(GeoUtil.toCoordinate(lngLatAlt));
            }
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    public static Coordinate toCoordinate(LngLatAlt lngLatAlt) {
        return new Coordinate(lngLatAlt.getLatitude(), lngLatAlt.getLongitude(), lngLatAlt.getAltitude());
    }

    private static Geometry createBox(BasicDBList coordinates) {
        Coordinate[] t = GeoUtil.parseCoordinates(coordinates);
        return GEOMETRY_FACTORY.toGeometry(new Envelope(t[0], t[1]));
    }

    private static Geometry createCircle(BasicDBList coordinates, boolean spherical) {
        Coordinate[] t = GeoUtil.parseCoordinates(coordinates);
        double radius = ((Number)coordinates.get(1)).doubleValue();
        radius = spherical ? (radius *= 6378100.0) : (radius *= 111185.0);
        return GeoUtil.createCircle(t[0].x, t[0].y, radius);
    }

    public static Geometry createCircle(double x, double y, double radius) {
        int sides = 32;
        Coordinate[] coords = new Coordinate[33];
        for (int i = 0; i < 32; ++i) {
            double angle = 360.0 * (double)i / 32.0;
            coords[i] = GeoUtil.destVincenty(x, y, angle, radius);
        }
        coords[32] = coords[0];
        LinearRing ring = GEOMETRY_FACTORY.createLinearRing(coords);
        return GEOMETRY_FACTORY.createPolygon(ring, null);
    }

    private static Coordinate destVincenty(double longitude, double latitude, double angle, double distanceInMeters) {
        double semiMajorAxis = 6378137.0;
        double b = 6356752.3142;
        double inverseFlattening = 0.0033528106647474805;
        double alpha1 = Math.toRadians(angle);
        double sinAlpha1 = Math.sin(alpha1);
        double cosAlpha1 = Math.cos(alpha1);
        double tanU1 = 0.9966471893352525 * Math.tan(Math.toRadians(latitude));
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double sigma1 = Math.atan2(tanU1, cosAlpha1);
        double sinAlpha = cosU1 * sinAlpha1;
        double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
        double uSq = cosSqAlpha * 2.723316066819453E11 / 4.0408299984087055E13;
        double aa = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double ab = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double sigma = distanceInMeters / (6356752.3142 * aa);
        double sigmaP = Math.PI * 2;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double cos2SigmaM = 0.0;
        double deltaSigma = 0.0;
        while (Math.abs(sigma - sigmaP) > 1.0E-12) {
            cos2SigmaM = Math.cos(2.0 * sigma1 + sigma);
            sinSigma = Math.sin(sigma);
            cosSigma = Math.cos(sigma);
            deltaSigma = ab * sinSigma * (cos2SigmaM + ab / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - ab / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
            sigmaP = sigma;
            sigma = distanceInMeters / (6356752.3142 * aa) + deltaSigma;
        }
        double tmp = sinU1 * sinSigma - cosU1 * cosSigma * cosAlpha1;
        double lat2 = Math.atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosAlpha1, 0.9966471893352525 * Math.sqrt(sinAlpha * sinAlpha + tmp * tmp));
        double lambda = Math.atan2(sinSigma * sinAlpha1, cosU1 * cosSigma - sinU1 * sinSigma * cosAlpha1);
        double c = 2.0955066654671753E-4 * cosSqAlpha * (4.0 + 0.0033528106647474805 * (4.0 - 3.0 * cosSqAlpha));
        double l = lambda - (1.0 - c) * 0.0033528106647474805 * sinAlpha * (sigma + c * sinSigma * (cos2SigmaM + c * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        return new Coordinate(GeoUtil.round(longitude + Math.toDegrees(l)), GeoUtil.round(Math.toDegrees(lat2)));
    }

    private static double round(double dis) {
        double mul = 1000000.0;
        return (double)Math.round(dis * mul) / mul;
    }

    private static Geometry createPolygon(BasicDBList coordinates) {
        Coordinate[] t = GeoUtil.parseCoordinates(coordinates);
        if (!t[0].equals((Object)t[t.length - 1])) {
            Coordinate[] another = new Coordinate[t.length + 1];
            System.arraycopy(t, 0, another, 0, t.length);
            another[t.length] = t[0];
            t = another;
        }
        return GEOMETRY_FACTORY.createPolygon(t);
    }

    private static Coordinate[] parseCoordinates(BasicDBList coordinates) {
        Coordinate[] ret = new Coordinate[coordinates.size()];
        int length = coordinates.size();
        for (int i = 0; i < length; ++i) {
            ret[i] = GeoUtil.coordinate(coordinates.get(i));
        }
        return ret;
    }

    public static class GeoDBObject
    extends BasicDBObject {
        private final Geometry geometry;

        public GeoDBObject(DBObject object, String indexKey) {
            Object coordinates = Util.extractField(object, indexKey);
            this.geometry = GeoUtil.toGeometry(coordinates);
            this.putAll((BSONObject)object);
            if (this.geometry == null) {
                LOG.warn("Can't extract geometry from this indexKey :{} (object:{}), coordinates:{}", new Object[]{indexKey, object, coordinates});
                throw new MongoException(16755, "insertDocument :: caused by :: 16755 Can't extract geo keys from object, malformed geometry?: " + FongoJSON.serialize(object));
            }
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public int hashCode() {
            return this.geometry.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeoDBObject)) {
                return false;
            }
            GeoDBObject that = (GeoDBObject)((Object)o);
            return this.geometry.equals(that.geometry);
        }

        public String toString() {
            return "GeoDBObject{geometry='" + this.geometry + '\'' + '}';
        }
    }
}

