/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.bitmaps;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMBitMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="setbit")
class SetBit
extends AbstractRedisOperation {
    SetBit(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMBitMap value = this.base().getBitMap(key);
        byte bit = Utils.convertToByte(this.params().get(2).toString());
        int pos = Utils.convertToNonNegativeInteger(this.params().get(1).toString());
        if (value == null) {
            RMBitMap bitMap = new RMBitMap();
            bitMap.setBit(bit, pos);
            this.base().putValue(key, bitMap);
            return Response.integer(0L);
        }
        boolean res = value.getBit(pos);
        value.setBit(bit, pos);
        this.base().putValue(key, value);
        return Response.integer(res ? 1L : 0L);
    }
}

