/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.CommandFactory;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.operations.connection.Select;
import com.github.fppt.jedismock.operations.scripting.Eval;
import com.github.fppt.jedismock.operations.scripting.Script;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.util.RedisInputStream;

public class LuaRedisCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LuaRedisCallback.class);
    private static final String NOSCRIPT_PREFIX = "NOSCRIPT ";
    private final OperationExecutorState state;

    public LuaRedisCallback(OperationExecutorState state) {
        this.state = state;
    }

    public LuaValue call(LuaValue args) {
        String operationName = args.get(1).tojstring();
        ArrayList<Slice> a = new ArrayList<Slice>();
        for (int i = 2; i <= args.length(); ++i) {
            LuaValue arg = args.get(i);
            if (arg instanceof LuaString) {
                a.add(Slice.create(((LuaString)arg).m_bytes));
                continue;
            }
            a.add(Slice.create(args.get(i).tojstring()));
        }
        return this.execute(operationName, a);
    }

    public LuaValue pcall(LuaValue args) {
        try {
            return this.call(args);
        }
        catch (Exception e) {
            LuaTable errorTable = new LuaTable();
            errorTable.set((LuaValue)LuaValue.valueOf((String)"err"), (LuaValue)LuaValue.valueOf((String)e.getMessage()));
            return errorTable;
        }
    }

    public String sha1hex(String x) {
        return Script.getScriptSHA(x);
    }

    public void log(int level, String message) {
        LOG.info("redis.log ({}, {})", (Object)level, (Object)message);
    }

    private LuaValue execute(String operationName, List<Slice> args) {
        RedisOperation operation;
        RedisOperation redisOperation = operation = "select".equalsIgnoreCase(operationName) ? new Select(this.state, args) : CommandFactory.buildOperation(operationName.toLowerCase(), true, this.state, args);
        if (operation != null) {
            LuaRedisCallback.throwOnUnsupported(operation);
            Slice result = operation.execute();
            if (Response.NULL.equals(result)) {
                return LuaValue.NONE;
            }
            byte[] data = result.data();
            return LuaRedisCallback.toLuaValue(new RedisInputStream((InputStream)new ByteArrayInputStream(data)));
        }
        throw new RuntimeException("Operation not implemented!");
    }

    private static void throwOnUnsupported(RedisOperation operation) {
        if (operation.getClass().equals(Eval.class)) {
            throw new RuntimeException("This Redis command is not allowed from scripts");
        }
    }

    private static LuaValue toLuaValue(RedisInputStream is) {
        byte b = is.readByte();
        switch (b) {
            case 43: {
                return LuaValue.valueOf((byte[])LuaRedisCallback.processStatusCodeReply(is));
            }
            case 36: {
                return LuaValue.valueOf((byte[])LuaRedisCallback.processBulkReply(is));
            }
            case 42: {
                return Eval.embedLuaListToValue(LuaRedisCallback.processMultiBulkReply(is));
            }
            case 58: {
                return LuaValue.valueOf((double)LuaRedisCallback.processInteger(is).longValue());
            }
            case 45: {
                String message = is.readLine();
                if (message.startsWith(NOSCRIPT_PREFIX)) {
                    throw new JedisNoScriptException(message);
                }
                throw new JedisDataException(message);
            }
        }
        return LuaValue.NONE;
    }

    private static byte[] processStatusCodeReply(RedisInputStream is) {
        return is.readLineBytes();
    }

    private static byte[] processBulkReply(RedisInputStream is) {
        int size;
        int len = is.readIntCrLf();
        if (len <= 0) {
            return new byte[0];
        }
        byte[] read = new byte[len];
        for (int offset = 0; offset < len; offset += size) {
            size = is.read(read, offset, len - offset);
            if (size != -1) continue;
            throw new RuntimeException("It seems like server has closed the connection.");
        }
        is.readByte();
        is.readByte();
        return read;
    }

    private static Long processInteger(RedisInputStream is) {
        return is.readLongCrLf();
    }

    private static List<LuaValue> processMultiBulkReply(RedisInputStream is) {
        int num = is.readIntCrLf();
        if (num <= 0) {
            return Collections.emptyList();
        }
        ArrayList<LuaValue> ret = new ArrayList<LuaValue>(num);
        for (int i = 0; i < num; ++i) {
            try {
                ret.add(LuaRedisCallback.toLuaValue(is));
                continue;
            }
            catch (JedisDataException e) {
                System.err.println(e.getMessage());
            }
        }
        return ret;
    }
}

