/*
 * Decompiled with CFR 0.152.
 */
package hthurow.tomcatjndi;

import hthurow.tomcatjndi.NamingContextListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.WebRuleSet;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.SAXException;

public class TomcatJNDI {
    private static final String URL_PKG_PREFIX = "org.apache.naming";
    private NamingResourcesImpl namingResources;
    private org.apache.catalina.core.NamingContextListener namingContextListener;
    private Server server;
    private StandardContext standardContext;
    private NamingContextListener globalNamingContextListener;
    private String hostName;
    private String engineName;
    private String contextName;

    public TomcatJNDI() {
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        String urlPkgPrefixes = System.getProperty("java.naming.factory.url.pkgs");
        urlPkgPrefixes = urlPkgPrefixes != null ? urlPkgPrefixes + ":" + URL_PKG_PREFIX : URL_PKG_PREFIX;
        System.setProperty("java.naming.factory.url.pkgs", urlPkgPrefixes);
    }

    private void initializeContext() {
        if (this.standardContext == null) {
            this.standardContext = new StandardContext();
            this.standardContext.setName("TomcatJNDI");
            this.standardContext.setParent((Container)new StandardHost());
            StandardEngine standardEngine = new StandardEngine();
            this.standardContext.getParent().setParent((Container)standardEngine);
            StandardService service = new StandardService();
            if (this.server == null) {
                this.server = new StandardServer();
            }
            service.setServer(this.server);
            standardEngine.setService((Service)service);
            this.namingResources = new NamingResourcesImpl();
            this.standardContext.setNamingResources(this.namingResources);
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setName("TomcatJNDI");
        }
    }

    public TomcatJNDI processContextXml(File contextXml) {
        this.initializeContext();
        Digester digester = new Digester();
        digester.push((Object)this.standardContext);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet((RuleSet)namingRuleSet);
        digester.addRuleSet((RuleSet)contextRuleSet);
        try {
            digester.parse(contextXml);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TomcatJNDI processServerXml(File serverXml) {
        if (this.server != null) throw new RuntimeException("There can only be one server.xml");
        if (!serverXml.getName().equals("server.xml")) throw new RuntimeException("Not a server.xml file");
        TomcatJNDICatalina catalina = new TomcatJNDICatalina();
        Digester digester = catalina.getDigester();
        digester.push((Object)catalina);
        try {
            digester.parse(serverXml);
            this.server = catalina.getServer();
            this.initializeGlobalNamingContext();
            this.initializeContextFromServerXml();
            return this;
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeGlobalNamingContext() {
        NamingResourcesImpl globalNamingResources = this.server.getGlobalNamingResources();
        this.globalNamingContextListener = new NamingContextListener();
        globalNamingResources.addPropertyChangeListener((PropertyChangeListener)((Object)this.globalNamingContextListener));
        this.globalNamingContextListener.setName("TomcatJNDIServer");
        this.globalNamingContextListener.lifecycleEvent(new LifecycleEvent((Lifecycle)this.server, "configure_start", null));
    }

    public TomcatJNDI processServerXml(File serverXml, String engineName, String hostName, String contextName) {
        Objects.requireNonNull(serverXml);
        this.engineName = Objects.requireNonNull(engineName);
        this.hostName = Objects.requireNonNull(hostName);
        this.contextName = Objects.requireNonNull(contextName);
        this.processServerXml(serverXml);
        return this;
    }

    public TomcatJNDI processServerXml(File serverXml, String contextName) {
        this.processServerXml(serverXml, "Catalina", "localhost", contextName);
        return this;
    }

    private void initializeContextFromServerXml() {
        if (this.contextName != null) {
            this.standardContext = (StandardContext)this.server.findService(this.engineName).getContainer().findChild(this.hostName).findChild(this.contextName);
            this.namingContextListener = this.standardContext.getNamingContextListener();
            if (this.namingContextListener == null) {
                this.namingContextListener = new NamingContextListener();
                this.namingContextListener.setName(this.standardContext.getName());
            }
            this.namingResources = this.standardContext.getNamingResources();
            this.namingResources.addPropertyChangeListener((PropertyChangeListener)this.namingContextListener);
        }
    }

    public TomcatJNDI processHostWebXml(File hostWebXml) {
        if (!hostWebXml.getName().equals("web.xml.default")) {
            throw new RuntimeException("Not a web.xml.default file");
        }
        this.processWebXml(hostWebXml, true);
        return this;
    }

    private void processWebXml(File anyWebXml, boolean setOverrideable) {
        this.initializeContext();
        Digester digester = new Digester();
        WebXml webXml = new WebXml();
        digester.push((Object)webXml);
        WebRuleSet webRuleSet = new WebRuleSet();
        webRuleSet.addRuleInstances(digester);
        try {
            digester.parse(anyWebXml);
            this.addEnvironment(webXml, setOverrideable);
            Collection resources = webXml.getResourceRefs().values();
            for (ContextResource resource : resources) {
                this.namingResources.addResource(resource);
            }
            Map ejbRefs = webXml.getEjbRefs();
            for (ContextEjb contextEjb : ejbRefs.values()) {
                this.namingResources.addEjb(contextEjb);
            }
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void addEnvironment(WebXml webXml, boolean setOverrideable) {
        Collection envEntries = webXml.getEnvEntries().values();
        for (ContextEnvironment envEntry : envEntries) {
            envEntry.setOverride(setOverrideable);
            this.namingResources.addEnvironment(envEntry);
        }
    }

    public TomcatJNDI processWebXml(File webXml) {
        this.processWebXml(webXml, true);
        return this;
    }

    void _processWebXml(File webXmlFile) {
        this.processWebXml(webXmlFile, true);
    }

    public TomcatJNDI processDefaultWebXml(File defaultWebXml) {
        this.processWebXml(defaultWebXml, false);
        return this;
    }

    public void start() {
        this.namingContextListener.lifecycleEvent(new LifecycleEvent((Lifecycle)this.standardContext, "configure_start", null));
    }

    public void tearDown() {
        if (this.namingContextListener != null) {
            this.namingContextListener.lifecycleEvent(new LifecycleEvent((Lifecycle)this.standardContext, "configure_stop", null));
            this.standardContext = null;
        }
        if (this.globalNamingContextListener != null) {
            this.globalNamingContextListener.lifecycleEvent(new LifecycleEvent((Lifecycle)this.server, "configure_stop", null));
        }
    }

    private static class TomcatJNDICatalina
    extends Catalina {
        private TomcatJNDICatalina() {
        }

        private Digester getDigester() {
            return super.createStartDigester();
        }
    }
}

