/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.config;

import com.github.hwywl.ant.task.config.ScheduledTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.stereotype.Component;

@Component
public class CronTaskRegistrar
implements DisposableBean {
    private final Map<Runnable, ScheduledTask> scheduledTasks = new ConcurrentHashMap<Runnable, ScheduledTask>(16);
    @Autowired
    private TaskScheduler taskScheduler;

    public void addCronTask(Runnable task, String cronExpression) {
        CronTask cronTask = new CronTask(task, cronExpression);
        if (this.scheduledTasks.containsKey(task)) {
            this.removeCronTask(task);
        }
        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.future = this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger());
        this.scheduledTasks.put(task, scheduledTask);
    }

    public void removeCronTask(Runnable task) {
        ScheduledTask scheduledTask = this.scheduledTasks.remove(task);
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
    }

    public void destroy() {
        for (ScheduledTask task : this.scheduledTasks.values()) {
            task.cancel();
        }
        this.scheduledTasks.clear();
    }
}

