/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.config;

import cn.hutool.core.util.StrUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ConfigurationProperties(prefix="ant-task.conf")
public class TaskConfig {
    public int poolSize = 6;
    public static String filePath;

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(this.poolSize);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("SysTaskThreadPool-");
        if (StrUtil.isEmpty((CharSequence)filePath)) {
            throw new RuntimeException("ant-task.conf.file-path \u914d\u7f6e\u4e3a\u7a7a");
        }
        return taskScheduler;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        TaskConfig.filePath = filePath;
    }
}

