/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.dao.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.github.hwywl.ant.task.config.TaskConfig;
import com.github.hwywl.ant.task.dao.SysTaskMapper;
import com.github.hwywl.ant.task.model.SysTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysTaskMapperImpl
implements SysTaskMapper {
    private static List<SysTask> tasks = new ArrayList<SysTask>();

    public SysTaskMapperImpl() {
        String filePath = TaskConfig.filePath;
        if (FileUtil.exist((String)filePath)) {
            List lines = FileUtil.readUtf8Lines((String)filePath);
            List taskList = lines.stream().map(e -> (SysTask)JSONUtil.toBean((String)e, SysTask.class)).collect(Collectors.toList());
            tasks.addAll(taskList);
        } else {
            FileUtil.touch((String)filePath);
        }
    }

    @Override
    public List<SysTask> findAllByTaskStatus(Integer status) {
        return tasks.stream().filter(task -> task.getTaskStatus().equals(status)).sorted(Comparator.comparing(SysTask::getCreateTime)).collect(Collectors.toList());
    }

    @Override
    public List<SysTask> findAll() {
        tasks.sort(Comparator.comparing(SysTask::getCreateTime));
        return tasks;
    }

    @Override
    public SysTask save(SysTask sysTask) {
        ArrayList<SysTask> collect = new ArrayList<SysTask>();
        sysTask.setTaskId("TaskId-" + RandomUtil.randomString((int)8));
        String day = DateUtil.date().setTimeZone(TimeZone.getTimeZone("GMT+8:00")).toString("yyyy-MM-dd HH:mm:ss");
        sysTask.setCreateTime(day);
        sysTask.setUpdateTime(day);
        collect.add(sysTask);
        collect.addAll(tasks);
        this.updateFile(collect);
        return sysTask;
    }

    @Override
    public void saveAndFlush(SysTask sysTask) {
        if (null == sysTask.getTaskId()) {
            this.save(sysTask);
        } else {
            String day = DateUtil.date().setTimeZone(TimeZone.getTimeZone("GMT+8:00")).toString("yyyy-MM-dd HH:mm:ss");
            sysTask.setUpdateTime(day);
            List<SysTask> collect = tasks.stream().filter(task -> !task.getTaskId().equals(sysTask.getTaskId())).collect(Collectors.toList());
            collect.add(sysTask);
            this.updateFile(collect);
        }
    }

    @Override
    public SysTask findById(String id) {
        SysTask sysTask = new SysTask();
        Optional<SysTask> optional = tasks.stream().filter(task -> task.getTaskId().equals(id)).findFirst();
        if (optional.isPresent()) {
            sysTask = optional.get();
        }
        return sysTask;
    }

    @Override
    public void delete(String id) {
        List<SysTask> taskList = tasks.stream().filter(task -> !task.getTaskId().equals(id)).collect(Collectors.toList());
        this.updateFile(taskList);
    }

    private void updateFile(List<SysTask> taskList) {
        tasks.clear();
        tasks.addAll(taskList);
        List collect = tasks.stream().map(JSONUtil::toJsonStr).collect(Collectors.toList());
        String filePath = TaskConfig.filePath;
        FileUtil.del((String)filePath);
        FileUtil.writeUtf8Lines(collect, (String)filePath);
    }
}

