/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.config;

import com.github.hwywl.ant.task.utils.SpringContextUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SchedulingRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingRunnable.class);
    private final String taskId;
    private final String beanName;
    private final String methodName;
    private final String params;
    private Object targetBean;
    private Method method;

    public SchedulingRunnable(String taskId, String beanName, String methodName, String params) {
        this.taskId = taskId;
        this.beanName = beanName;
        this.methodName = methodName;
        this.params = params;
        try {
            this.targetBean = SpringContextUtil.getBean(beanName);
            this.method = StringUtils.hasText((String)params) ? this.targetBean.getClass().getDeclaredMethod(methodName, String.class) : this.targetBean.getClass().getDeclaredMethod(methodName, new Class[0]);
            ReflectionUtils.makeAccessible((Method)this.method);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c - taskId\uff1a{}\uff0cbean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.taskId, this.beanName, this.methodName, this.params});
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtils.hasText((String)this.params)) {
                this.method.invoke(this.targetBean, this.params);
            } else {
                this.method.invoke(this.targetBean, new Object[0]);
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - taskId\uff1a%s\uff0cbean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s ", this.taskId, this.beanName, this.methodName, this.params), (Throwable)ex);
        }
        long times = System.currentTimeMillis() - startTime;
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - taskId\uff1a{}\uff0cbean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{this.taskId, this.beanName, this.methodName, this.params, times});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunnable that = (SchedulingRunnable)o;
        if (this.params == null) {
            return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && that.params == null;
        }
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && this.params.equals(that.params);
    }

    public int hashCode() {
        if (this.params == null) {
            return Objects.hash(this.beanName, this.methodName);
        }
        return Objects.hash(this.beanName, this.methodName, this.params);
    }
}

