/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.controller;

import com.github.hwywl.ant.task.model.SysTask;
import com.github.hwywl.ant.task.service.SysTaskService;
import com.github.hwywl.ant.task.utils.MessageResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tasks"})
public class SysTaskController {
    @Autowired
    SysTaskService sysTaskService;

    @GetMapping(value={"/allTasks"})
    public List<SysTask> getAllTasks() {
        return this.sysTaskService.getAllTasks();
    }

    @PostMapping(value={"/addTask"})
    public MessageResult addTask(@RequestBody SysTask sysTask) {
        Boolean flag = this.sysTaskService.addTask(sysTask);
        if (flag.booleanValue()) {
            return MessageResult.ok("\u4efb\u52a1\u6dfb\u52a0\u6210\u529f");
        }
        return MessageResult.error("\u4efb\u52a1\u91cd\u590d\uff0c\u6dfb\u52a0\u5931\u8d25");
    }

    @PutMapping(value={"/updateTask"})
    public MessageResult updateTask(@RequestBody SysTask sysTask) {
        Boolean flag = this.sysTaskService.updateTask(sysTask);
        if (flag.booleanValue()) {
            return MessageResult.ok("\u4efb\u52a1\u66f4\u65b0\u6210\u529f");
        }
        return MessageResult.error("\u4efb\u52a1\u66f4\u65b0\u5931\u8d25");
    }

    @DeleteMapping(value={"/deleteTask"})
    public MessageResult deleteTask(String id) {
        Boolean flag = this.sysTaskService.deleteTasksById(id);
        if (flag.booleanValue()) {
            return MessageResult.ok("\u5220\u9664\u6210\u529f");
        }
        return MessageResult.error("\u5220\u9664\u5931\u8d25");
    }
}

