/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.ant.task.service;

import com.github.hwywl.ant.task.config.CronTaskRegistrar;
import com.github.hwywl.ant.task.config.SchedulingRunnable;
import com.github.hwywl.ant.task.dao.SysTaskMapper;
import com.github.hwywl.ant.task.model.SysTask;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTaskService {
    @Autowired
    SysTaskMapper sysTaskMapper;
    @Autowired
    CronTaskRegistrar cronTaskRegistrar;

    public List<SysTask> getAllTasks() {
        return this.sysTaskMapper.findAll();
    }

    public Boolean addTask(SysTask sysTask) {
        List<SysTask> all = this.sysTaskMapper.findAll();
        for (SysTask task : all) {
            if (!task.equals(sysTask)) continue;
            return false;
        }
        SysTask sj = this.sysTaskMapper.save(sysTask);
        SchedulingRunnable schedulingRunnable = new SchedulingRunnable(sysTask.getTaskId(), sysTask.getBeanName(), sysTask.getMethodName(), sysTask.getMethodParams());
        if (sj.getTaskStatus() == 1) {
            this.cronTaskRegistrar.addCronTask(schedulingRunnable, sysTask.getCronExpression());
        }
        return true;
    }

    public List<SysTask> getTasksByStatus(int status) {
        return this.sysTaskMapper.findAllByTaskStatus(status);
    }

    public Boolean updateTask(SysTask sysTask) {
        this.sysTaskMapper.saveAndFlush(sysTask);
        SchedulingRunnable schedulingRunnable = new SchedulingRunnable(sysTask.getTaskId(), sysTask.getBeanName(), sysTask.getMethodName(), sysTask.getMethodParams());
        if (sysTask.getTaskStatus() == 1) {
            this.cronTaskRegistrar.addCronTask(schedulingRunnable, sysTask.getCronExpression());
        } else {
            this.cronTaskRegistrar.removeCronTask(schedulingRunnable);
        }
        return true;
    }

    public Boolean deleteTasksById(String id) {
        SysTask sysTask = this.sysTaskMapper.findById(id);
        SchedulingRunnable schedulingRunnable = new SchedulingRunnable(sysTask.getTaskId(), sysTask.getBeanName(), sysTask.getMethodName(), sysTask.getMethodParams());
        this.cronTaskRegistrar.removeCronTask(schedulingRunnable);
        this.sysTaskMapper.delete(id);
        return true;
    }
}

