/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jdeps;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

final class JDepsCommandUtil {
    private final ToolchainManager toolchainManager;
    private final Log log;
    private final MavenSession session;

    JDepsCommandUtil(ToolchainManager toolchainManager, Log log, MavenSession session) {
        this.toolchainManager = toolchainManager;
        this.log = log;
        this.session = session;
    }

    String getJdepsExecutable() throws IOException {
        String jdepsExecutable = null;
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain != null) {
            this.log.info((CharSequence)("Toolchain in jdeps-maven-plugin: " + toolchain));
            jdepsExecutable = toolchain.findTool("jdeps");
        }
        String jdepsCommand = "jdeps" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty(jdepsExecutable)) {
            Path jdepsExe = Paths.get(jdepsExecutable, new String[0]);
            if (Files.isDirectory(jdepsExe, new LinkOption[0])) {
                jdepsExe = jdepsExe.resolve(jdepsCommand);
            }
            String fileName = jdepsExe.getFileName().toString();
            if (SystemUtils.IS_OS_WINDOWS && fileName.indexOf(46) < 0) {
                jdepsExe = jdepsExe.resolveSibling(fileName + ".exe");
            }
            if (!Files.isRegularFile(jdepsExe, new LinkOption[0])) {
                throw new IOException("The jdeps executable '" + jdepsExe + "' doesn't exist or is not a file.");
            }
            return jdepsExe.toAbsolutePath().toString();
        }
        Path javaHomePath = Paths.get(SystemUtils.getJavaHome().toURI());
        Path jdepsExe = JDepsCommandUtil.tryResolveJdeps(javaHomePath, jdepsCommand);
        if (jdepsExe == null) {
            jdepsExe = JDepsCommandUtil.tryResolveJdeps(javaHomePath.getParent(), jdepsCommand);
        }
        if (jdepsExe == null) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            javaHomePath = Paths.get(javaHome, new String[0]);
            if (!Files.exists(javaHomePath, new LinkOption[0]) || !Files.isDirectory(javaHomePath, new LinkOption[0])) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            jdepsExe = JDepsCommandUtil.tryResolveJdeps(javaHomePath, jdepsCommand);
        }
        if (jdepsExe == null) {
            throw new IOException("The jdeps executable '" + jdepsExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return jdepsExe.toAbsolutePath().toString();
    }

    private static Path tryResolveJdeps(Path javaHome, String jdepsCommand) {
        Path resolved;
        Path javaHomeBin = javaHome.resolve("bin");
        if (Files.exists(javaHomeBin, new LinkOption[0]) && Files.isDirectory(javaHomeBin, new LinkOption[0]) && Files.exists(resolved = javaHomeBin.resolve(jdepsCommand), new LinkOption[0]) && Files.isRegularFile(resolved, new LinkOption[0])) {
            return resolved;
        }
        return null;
    }
}

