/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ArrayResource;
import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.CallResourceFactory;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

abstract class AbstractArrayFactory
implements CallResourceFactory {
    final int argumentIndex;
    final String typeName;

    AbstractArrayFactory(int argumentIndex, String typeName) {
        this.argumentIndex = argumentIndex;
        this.typeName = typeName;
    }

    CallResource createArrayOf(Connection connection, Object[] args) throws SQLException {
        Object[] elements = this.extractElements(args);
        java.sql.Array array = connection.createArrayOf(this.typeName, elements);
        return new ArrayResource(array, this.argumentIndex);
    }

    private Object[] extractElements(Object[] args) {
        Object elements = args[this.argumentIndex];
        if (elements instanceof Collection) {
            return ((Collection)elements).toArray();
        }
        if (elements instanceof Object[]) {
            return (Object[])elements;
        }
        if (elements.getClass().isArray()) {
            int length = Array.getLength(elements);
            Object[] array = new Object[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(elements, i);
            }
            return array;
        }
        throw new IllegalArgumentException("argument at index: " + this.argumentIndex + " expected to be a collection or array but was not");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[argumentIndex=" + this.argumentIndex + ", typeName=" + this.typeName + ']';
    }
}

