/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class AbstractValueExtractorResultExtractor
implements ResultExtractor {
    private final int extractorIndex;
    private final int fetchSize;

    AbstractValueExtractorResultExtractor(int extractorIndex, int fetchSize) {
        this.extractorIndex = extractorIndex;
        this.fetchSize = fetchSize;
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        if (this.fetchSize != 0) {
            statement.setFetchSize(this.fetchSize);
        }
        Object extractor = args[this.extractorIndex];
        boolean hasResultSet = statement.execute();
        if (hasResultSet) {
            try (ResultSet rs = statement.getResultSet();){
                Object object = this.read(rs, extractor);
                return object;
            }
        }
        try (ResultSet rs = AbstractValueExtractorResultExtractor.getOutResultSet(statement, outParameterRegistration);){
            Object object = this.read(rs, extractor);
            return object;
        }
    }

    abstract Object read(ResultSet var1, Object var2) throws SQLException;

    private static ResultSet getOutResultSet(CallableStatement statement, OutParameterRegistration outParameterRegistration) throws SQLException {
        return outParameterRegistration.getOutParamter(statement, ResultSet.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[methodParameterIndex=" + this.extractorIndex + ", fetchSize=" + ToStringUtils.fetchSizeToString(this.fetchSize) + ']';
    }
}

