/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.CallResource;
import java.sql.Array;
import java.sql.SQLException;

final class ArrayResource
implements CallResource {
    private final Array array;
    private final int arrayIndex;

    ArrayResource(Array array, int arrayIndex) {
        this.array = array;
        this.arrayIndex = arrayIndex;
    }

    @Override
    public void close() throws SQLException {
        this.array.free();
    }

    @Override
    public boolean hasResourceAt(int index) {
        return index == this.arrayIndex;
    }

    @Override
    public Object resourceAt(int index) {
        if (index != this.arrayIndex) {
            throw new IllegalArgumentException("no resource at: " + index);
        }
        return this.array;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.arrayIndex + ']';
    }
}

