/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class ArrayResultExtractor
implements ResultExtractor {
    private final Class<?> arrayElementType;

    ArrayResultExtractor(Class<?> arrayElementType) {
        this.arrayElementType = arrayElementType;
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        boolean hasResultSet = statement.execute();
        if (hasResultSet) {
            try (ResultSet rs = statement.getResultSet();){
                rs.next();
                java.sql.Array jdbcArray = rs.getArray(1);
                Object object = this.extractValue(jdbcArray);
                return object;
            }
        }
        java.sql.Array array = outParameterRegistration.getOutParamter(statement, java.sql.Array.class);
        return this.extractValue(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractValue(java.sql.Array jdbcArray) throws SQLException {
        try {
            Object array = jdbcArray.getArray();
            Class<?> arrayClass = array.getClass();
            if (!arrayClass.isArray()) {
                throw new ClassCastException("expected array of " + this.arrayElementType + " but got " + arrayClass);
            }
            Class<?> actualComponentType = arrayClass.getComponentType();
            if (actualComponentType == this.arrayElementType) {
                Object object = array;
                return object;
            }
            Object object = this.convertElementType(array, actualComponentType);
            return object;
        }
        finally {
            jdbcArray.free();
        }
    }

    private Object convertElementType(Object array, Class<?> actualComponentType) {
        if (actualComponentType != Object.class && actualComponentType.isPrimitive() == this.arrayElementType.isPrimitive()) {
            throw new ClassCastException("expected array of " + this.arrayElementType + " but got array of " + actualComponentType);
        }
        int length = Array.getLength(array);
        Object value = Array.newInstance(this.arrayElementType, length);
        for (int i = 0; i < length; ++i) {
            Object elementValue = Array.get(array, i);
            Array.set(value, i, elementValue);
        }
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + ToStringUtils.classNameToString(this.arrayElementType) + ']';
    }
}

