/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ArrayResultExtractor;
import com.github.marschall.storedprocedureproxy.OracleArrayResultExtractor;
import com.github.marschall.storedprocedureproxy.ResultExtractor;

@FunctionalInterface
interface ArrayResultExtractorFactory {
    public static final ArrayResultExtractorFactory JDBC = methodReturnType -> new ArrayResultExtractor(methodReturnType.getComponentType());
    public static final ArrayResultExtractorFactory ORACLE = methodReturnType -> {
        Class<?> componentType = methodReturnType.getComponentType();
        if (OracleArrayResultExtractor.isSupportedElementType(componentType)) {
            return new OracleArrayResultExtractor(componentType);
        }
        return new ArrayResultExtractor(componentType);
    };

    public ResultExtractor newArrayResultExtractor(Class<?> var1);
}

