/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ByteUtils;
import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.InParameterRegistration;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.SQLException;

final class ByIndexAndTypeInParameterRegistration
implements InParameterRegistration {
    private final byte[] inParameterIndices;
    private final int[] inParameterTypes;

    ByIndexAndTypeInParameterRegistration(byte[] inParameterIndices, int[] inParameterTypes) {
        this.inParameterIndices = inParameterIndices;
        this.inParameterTypes = inParameterTypes;
    }

    private int inParameterIndexAt(int i) {
        return ByteUtils.toByte(this.inParameterIndices[i]);
    }

    @Override
    public void bindInParamters(CallableStatement statement, CallResource callResource, Object[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            int parameterIndex = this.inParameterIndexAt(i);
            if (parameterIndex == 0) continue;
            Object arg = callResource.hasResourceAt(i) ? callResource.resourceAt(i) : args[i];
            int type = this.inParameterTypes[i];
            if (arg != null) {
                if (InParameterRegistration.hasScale(type) && arg instanceof BigDecimal) {
                    statement.setObject(parameterIndex, arg, type, ((BigDecimal)arg).scale());
                    continue;
                }
                statement.setObject(parameterIndex, arg, type);
                continue;
            }
            statement.setNull(parameterIndex, type);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[indexes={");
        ByteUtils.toStringOn(this.inParameterIndices, builder);
        builder.append("}, types={");
        ToStringUtils.toStringOn(this.inParameterTypes, builder);
        builder.append("}]");
        return builder.toString();
    }
}

